<?php
/**
 * Created by PhpStorm.
 * User: Philipp.Holzmann
 * Date: 03.02.2020
 * Time: 15:13
 */
namespace SicoCreditPlus\Core\Content\CreditPlusPayment;

use Shopware\Core\Checkout\Order\OrderDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\Field\FkField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\PrimaryKey;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\Required;
use Shopware\Core\Framework\DataAbstractionLayer\Field\IdField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\IntField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ManyToOneAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ReferenceVersionField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\StringField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\VersionField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;

class CreditPlusPaymentDefinition extends EntityDefinition{

	public const ENTITY_NAME = 'sico_credit_plus_payment';

	public function getEntityName(): string
	{
		return self::ENTITY_NAME;
	}

	public function getEntityClass(): string
	{
		return CreditPlusPaymentEntity::class;
	}

	public function getCollectionClass(): string
	{
		return CreditPlusPaymentCollection::class;
	}

	protected function defineFields(): FieldCollection
	{
		return new FieldCollection([
			(new IdField('id', 'id'))->addFlags(new Required(), new PrimaryKey()),
			new VersionField(),
			(new FkField('order_id', 'orderId', OrderDefinition::class)),
			new ReferenceVersionField(OrderDefinition::class),
			(new IntField('gen_timestamp', 'genTimestamp'))->addFlags(new Required()),
			(new StringField('url', 'url')),
			(new StringField('orderNumber', 'orderNumber')),
			(new ManyToOneAssociationField('order', 'order_id', OrderDefinition::class, 'id', true)),
			(new StringField('order_finish','orderFinish',400)),
			(new StringField('token','token')),
			(new StringField('back_url','backUrl',400)),
			(new StringField('status_change_url','statusChangeUrl',400)),
		]);
	}
}
