<?php
/**
 * Created by PhpStorm.
 * User: Philipp.Holzmann
 * Date: 03.02.2020
 * Time: 15:13
 */


namespace SicoCreditPlus\Core\Content\CreditPlusPayment;

use Shopware\Core\Checkout\Order\OrderEntity;
use Shopware\Core\Framework\DataAbstractionLayer\Entity;
use Shopware\Core\Framework\DataAbstractionLayer\EntityIdTrait;

class CreditPlusPaymentEntity extends Entity{
	use EntityIdTrait;

	/** @var ?string */
	protected $orderId;
	/** @var ?OrderEntity */
	protected $order;
	/** @var string */
	protected $url;
	/** @var int */
	protected $genTimestamp;
	/** @var string */
	protected $orderNumber;
	/** @var string */
	protected $orderFinish;
	/** @var string */
	protected $token;
	/** @var string */
	protected $backUrl;
	/** @var string */
	protected $statusChangeUrl;

	/**
	 * @return string
	 */
	public function getOrderId(): ?string
	{
		return $this->orderId;
	}

	/**
	 * @param string $orderId
	 */
	public function setOrderId(?string $orderId): void
	{
		$this->orderId = $orderId;
	}

	/**
	 * @return OrderEntity
	 */
	public function getOrder(): ?OrderEntity
	{
		return $this->order;
	}

	/**
	 * @param OrderEntity $order
	 */
	public function setOrder(?OrderEntity $order): void
	{
		$this->order = $order;
	}

	/**
	 * @return string
	 */
	public function getUrl(): ?string
	{
		return $this->url;
	}

	/**
	 * @param string $url
	 */
	public function setUrl(string $url): void
	{
		$this->url = $url;
	}

	/**
	 * @return int
	 */
	public function getGenTimestamp(): int
	{
		return $this->genTimestamp;
	}

	/**
	 * @param int $timestamp
	 */
	public function setGenTimestamp(int $timestamp): void
	{
		$this->genTimestamp = $timestamp;
	}

	/**
	 * @return string
	 */
	public function getOrderNumber(): string
	{
		return $this->orderNumber;
	}

	/**
	 * @param string $orderNumber
	 */
	public function setOrderNumber(string $orderNumber): void
	{
		$this->orderNumber = $orderNumber;
	}

	/**
	 * @return string
	 */
	public function getOrderFinish(): ?string
	{
		return $this->orderFinish;
	}

	/**
	 * @param string $orderFinish
	 */
	public function setOrderFinish(string $orderFinish): void
	{
		$this->orderFinish = $orderFinish;
	}

	/**
	 * @return string
	 */
	public function getToken(): ?string
	{
		return $this->token;
	}

	/**
	 * @param string $token
	 */
	public function setToken(?string $token): void
	{
		$this->token = $token;
	}

	/**
	 * @return string
	 */
	public function getBackUrl(): ?string
	{
		return $this->backUrl;
	}

	/**
	 * @param string $backUrl
	 */
	public function setBackUrl(string $backUrl): void
	{
		$this->backUrl = $backUrl;
	}

	/**
	 * @return string
	 */
	public function getStatusChangeUrl(): ?string
	{
		return $this->statusChangeUrl;
	}

	/**
	 * @param string $statusChangeUrl
	 */
	public function setStatusChangeUrl(string $statusChangeUrl): void
	{
		$this->statusChangeUrl = $statusChangeUrl;
	}





}
