<?php
/**
 * Created by PhpStorm.
 * User: philipp.holzmann
 * Date: 26.07.2021
 * Time: 08:10
 */
namespace SicoCreditPlus\Core\Content\Order;

use Shopware\Core\Checkout\Order\OrderDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\CascadeDelete;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToManyAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use SicoCreditPlus\Core\Content\CreditPlusPayment\CreditPlusPaymentDefinition;

if ( interface_exists('Shopware\Core\Framework\DataAbstractionLayer\EntityExtensionInterface') ) {
	class OrderExtensionBase implements \Shopware\Core\Framework\DataAbstractionLayer\EntityExtensionInterface {
		public function extendFields(FieldCollection $collection ): void {

		}

		public function getDefinitionClass(): string {
			return OrderDefinition::class;
		}
	}
} else {
	class OrderExtensionBase extends \Shopware\Core\Framework\DataAbstractionLayer\EntityExtension {
		public function extendFields(FieldCollection $collection ): void {

		}

		public function getDefinitionClass(): string {
			return OrderDefinition::class;
		}
	}
}

class OrderExtension extends OrderExtensionBase {
	public function extendFields(FieldCollection $collection): void
	{
		$collection->add(
			(new OneToManyAssociationField(
				'creditPlusPayment',
				CreditPlusPaymentDefinition::class,
				'order_id'))->addFlags(new CascadeDelete())
		);
	}

	public function getDefinitionClass(): string
	{
		return OrderDefinition::class;
	}

}
