<?php
/**
 * Created by PhpStorm.
 * @author mihovil.bubnjar
 * @date 26.06.2024
 * @time 10:50
 */

namespace SicoCreditPlus\Core\Content\ProductExport\Service;

use Shopware\Core\Content\Product\SalesChannel\SalesChannelProductEntity;
use Shopware\Core\Content\ProductExport\ProductExportEntity;
use Shopware\Core\Content\ProductExport\Service\ProductExportRendererInterface;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use SicoCreditPlus\Core\Content\SicoCreditPlusCalculatedRate\SicoCreditPlusCalculatedRateCollection;
use SicoCreditPlus\Subscriber\ProductListingSubscriber;

class ProductExportRendererExtension implements ProductExportRendererInterface
{
	protected ProductExportRendererInterface $oParent;
	protected EntityRepository $oCalculatedRateRepository;

	public function __construct(ProductExportRendererInterface $oParent, EntityRepository $oCalculatedRateRepository)
	{
		$this->oParent = $oParent;
		$this->oCalculatedRateRepository = $oCalculatedRateRepository;
	}

	public function renderHeader(ProductExportEntity $productExport, SalesChannelContext $salesChannelContext): string
	{
		return $this->oParent->renderHeader($productExport, $salesChannelContext);
	}

	public function renderFooter(ProductExportEntity $productExport, SalesChannelContext $salesChannelContext): string
	{
		return $this->oParent->renderFooter($productExport, $salesChannelContext);
	}

	public function renderBody(ProductExportEntity $productExport, SalesChannelContext $salesChannelContext, array $data): string
	{
		/** @var SalesChannelProductEntity $oProduct */
		$oProduct = $data['product'];

		/** @see ProductListingSubscriber::onProductExportProductCriteria() The virtual field gets added there */
		/** @var SicoCreditPlusCalculatedRateCollection $oCalculatedRates */
		$oCalculatedRates = $oProduct->get('sicoCreditPlusCalculatedRates');
		$aAvailableRates = [];
		foreach ( $oCalculatedRates as $oCalculatedRate ) {
			if ( $oCalculatedRate->getSicoCalculationFinished() == 0 ) {
				// Not yet calculated
				continue;
			}
			if ( $oCalculatedRate->getSicoSalesChannelId() !== $salesChannelContext->getSalesChannelId() ) {
				// Not this sales channel
				continue;
			}
			if (
				$oCalculatedRate->getSicoMinMonths() === -1 &&
				$oCalculatedRate->getSicoMaxMonths() === -1 &&
				$oCalculatedRate->getSicoAbsoluteMinRateMonths() === -1 &&
				$oCalculatedRate->getSicoFictionalMinRateMonths() === -1
			) {
				// No rates available
				continue;
			}
			$aAvailableRates[] = $oCalculatedRate;
		}
		$data['product']->sicoCreditPlusCalculatedRates = $aAvailableRates;
		return $this->oParent->renderBody($productExport, $salesChannelContext, $data);
	}
}
