<?php

namespace SicoCreditPlus\Core\Content\SalesChannel;


use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\CascadeDelete;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToManyAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use Shopware\Core\System\SalesChannel\SalesChannelDefinition;
use SicoCreditPlus\Core\Content\SicoProductgroupSalesChannel\SicoProductgroupSalesChannelDefinition;

if ( interface_exists('Shopware\Core\Framework\DataAbstractionLayer\EntityExtensionInterface') ) {
    class SalesChannelExtensionBase implements \Shopware\Core\Framework\DataAbstractionLayer\EntityExtensionInterface {
        public function extendFields(FieldCollection $collection ): void {

        }

        public function getDefinitionClass(): string {
            return SalesChannelDefinition::class;
        }
    }
} else {
    class SalesChannelExtensionBase extends \Shopware\Core\Framework\DataAbstractionLayer\EntityExtension {
        public function extendFields(FieldCollection $collection ): void {

        }

        public function getDefinitionClass(): string {
            return SalesChannelDefinition::class;
        }
    }
}
class SalesChannelExtension extends SalesChannelExtensionBase {
    public function extendFields(FieldCollection $collection): void
    {
        $collection->add(
            (new OneToManyAssociationField(
                'prodgroupSalesChannel',
                SicoProductgroupSalesChannelDefinition::class,
                'productgroup_id'))->addFlags(new CascadeDelete())
        );
    }

    public function getDefinitionClass(): string
    {
        return SalesChannelDefinition::class;
    }

}
