<?php
/**
 * Created by PhpStorm.
 * @author mihovil.bubnjar
 * @date 24.06.2024
 * @time 11:49
 */

namespace SicoCreditPlus\Core\Content\SicoCreditPlusCalculatedRate;

use Shopware\Core\Content\Product\ProductDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\Field\BoolField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\CreatedAtField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\FkField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\PrimaryKey;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\Required;
use Shopware\Core\Framework\DataAbstractionLayer\Field\FloatField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\IdField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\IntField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ManyToOneAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\UpdatedAtField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use Shopware\Core\System\Currency\CurrencyDefinition;
use Shopware\Core\System\SalesChannel\SalesChannelDefinition;

class SicoCreditPlusCalculatedRateDefinition extends EntityDefinition
{
	public const ENTITY_NAME = 'sico_credit_plus_calculated_rate';
	public function getEntityName(): string
	{
		return self::ENTITY_NAME;
	}

	public function getEntityClass(): string
	{
		return SicoCreditPlusCalculatedRateEntity::class;
	}

	public function getCollectionClass(): string
	{
		return SicoCreditPlusCalculatedRateCollection::class;
	}

	protected function defineFields(): FieldCollection
	{
		return new FieldCollection([
			(new IdField('id','id'))->addFlags(new Required(),new PrimaryKey()),
			(new IntField('sico_min_months','sicoMinMonths')),
			(new FloatField('sico_min_months_interest_rate','sicoMinMonthsInterestRate')),
			(new FloatField('sico_min_months_rate','sicoMinMonthsRate')),
			(new IntField('sico_max_months','sicoMaxMonths')),
			(new FloatField('sico_max_months_interest_rate','sicoMaxMonthsInterestRate')),
			(new FloatField('sico_max_months_rate','sicoMaxMonthsRate')),
			(new IntField('sico_absolute_min_rate_months','sicoAbsoluteMinRateMonths')),
			(new FloatField('sico_absolute_min_rate_interest_rate','sicoAbsoluteMinRateInterestRate')),
			(new FloatField('sico_absolute_min_rate_rate','sicoAbsoluteMinRateRate')),
			(new IntField('sico_fictional_min_rate_months','sicoFictionalMinRateMonths')),
			(new FloatField('sico_fictional_min_rate_interest_rate','sicoFictionalMinRateInterestRate')),
			(new FloatField('sico_fictional_min_rate_rate','sicoFictionalMinRateRate')),
			(new BoolField('sico_calculation_finished','sicoCalculationFinished')),
			(new FkField('sico_currency_id','sicoCurrencyId',CurrencyDefinition::class)),
			(new ManyToOneAssociationField('sicoCurrency','sico_currency_id',CurrencyDefinition::class)),
			(new FkField('product_id','productId',ProductDefinition::class)),
			(new ManyToOneAssociationField('sicoProduct','product_id',ProductDefinition::class)),
			(new FkField('sico_sales_channel_id','sicoSalesChannelId',SalesChannelDefinition::class)),
			(new ManyToOneAssociationField('sicoSalesChannel','sico_sales_channel_id',SalesChannelDefinition::class)),
			(new CreatedAtField()),
			(new UpdatedAtField())
		]);
	}
}
