<?php
/**
 * Created by PhpStorm.
 * User: Philipp.Holzmann
 * Date: 08.01.2020
 * Time: 14:27
 */
namespace SicoCreditPlus\Core\Content\SicoProductgroup;

use Shopware\Core\Content\Product\ProductDefinition;
use Shopware\Core\Content\ProductStream\ProductStreamDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\Field\FkField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\CascadeDelete;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\PrimaryKey;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\Required;
use Shopware\Core\Framework\DataAbstractionLayer\Field\IdField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\IntField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ManyToManyAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ManyToOneAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToManyAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\StringField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use SicoCreditPlus\Core\Content\SicoOfferedOption\SicoOfferedOptionDefinition;
use SicoCreditPlus\Core\Content\SicoProductgroupProducts\SicoProductgroupProductsDefinition;
use SicoCreditPlus\Core\Content\SicoProductgroupSalesChannel\SicoProductgroupSalesChannelDefinition;

class SicoProductgroupDefinition extends EntityDefinition{

	public const ENTITY_NAME = 'sico_productgroup';

	public function getEntityName(): string
	{
		return self::ENTITY_NAME;
	}

	public function getCollectionClass(): string
	{
		return SicoProductgroupCollection::class;
	}

	public function getEntityClass(): string
	{
		return SicoProductgroupEntity::class;
	}


	protected function defineFields(): FieldCollection
	{
		return new FieldCollection([
			(new IdField('id','id'))->addFlags(new Required(),new PrimaryKey()),
			(new StringField('sico_name','sicoName')),
			(new IntField('sico_product_type_id','sicoProductTypeId')),
			(new IntField('sico_product_class_id','sicoProductClassId')),
			(new ManyToManyAssociationField('product',ProductDefinition::class,SicoProductgroupProductsDefinition::class,'productgroup_id','product_id')),
			(new OneToManyAssociationField('offeredOptions',SicoOfferedOptionDefinition::class,'sico_prodgroup')),
            (new OneToManyAssociationField('prodgroupSalesChannel',SicoProductgroupSalesChannelDefinition::class,'productgroup_id'))->addFlags(new CascadeDelete()),
			(new FkField('dynamic_product_group','dynamicProductGroupId',ProductStreamDefinition::class)),
			(new ManyToOneAssociationField('dynamicProductGroup', 'dynamic_product_group', ProductStreamDefinition::class, 'id', true))
		]);
	}
}
