<?php
namespace SicoCreditPlus\Core\Content\SicoProductgroupSalesChannel;

use Shopware\Core\Framework\DataAbstractionLayer\EntityDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\Field\FkField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\PrimaryKey;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\Required;
use Shopware\Core\Framework\DataAbstractionLayer\Field\IdField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ManyToOneAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use Shopware\Core\System\SalesChannel\SalesChannelDefinition;
use SicoCreditPlus\Core\Content\SicoProductgroup\SicoProductgroupDefinition;

class SicoProductgroupSalesChannelDefinition extends EntityDefinition{
    public const ENTITY_NAME = 'sico_productgroup_sales_channel';

    public function getEntityName(): string
    {
        return self::ENTITY_NAME;
    }

    public function getCollectionClass(): string
    {
        return SicoProductgroupSalesChannelCollection::class;
    }

    public function getEntityClass(): string
    {
        return SicoProductgroupSalesChannelEntity::class;
    }

    protected function defineFields(): FieldCollection
    {
        return new FieldCollection([
            (new IdField('id','id'))->addFlags(new Required(),new PrimaryKey()),
            (new FkField('productgroup_id','productgroupId',SicoProductgroupDefinition::class))->addFlags(new Required()),
            (new FkField('sales_channel_id','salesChannelId',SalesChannelDefinition::class))->addFlags(new Required()),
            new ManyToOneAssociationField('salesChannel','sales_channel_id',SalesChannelDefinition::class,'id',false),
            new ManyToOneAssociationField('productgroup','productgroup_id',SicoProductgroupDefinition::class,'id',false),
        ]);
    }
}
