<?php declare(strict_types=1);

namespace SicoCreditPlus\Migration;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\DBALException;
use Shopware\Core\Framework\Migration\MigrationStep;
use Shopware\Core\Framework\Migration\InheritanceUpdaterTrait;

class Migration1578559126Init extends MigrationStep
{
	use InheritanceUpdaterTrait;
    public function getCreationTimestamp(): int
    {
        return 1578559126;
    }

    public function update(Connection $connection): void
    {

		$connection->executeStatement('
create table IF NOT EXISTS sico_productgroup
(
	id                    BINARY(16) primary key,
	sico_name             varchar(255) not null,
	sico_product_type_id  varchar(255) not null,
	sico_product_class_id varchar(255) not null,
	`created_at` DATETIME(3) NOT NULL,
	`updated_at` DATETIME(3) NULL
)');


		$connection->executeStatement('
CREATE TABLE IF NOT EXISTS sico_offered_option(
  `id` BINARY(16) NOT NULL,
  `sico_prodgroup` BINARY(16),
  `sico_months` int(11),
  `sico_interest` double,
  `sico_prodcode` varchar(255),
  `sico_active` tinyint(1),
  `sico_ratefactor` double,
  `created_at` DATETIME(3) NOT NULL,
  `updated_at` DATETIME(3) NULL,
  PRIMARY KEY(`id`),
  FOREIGN KEY (`sico_prodgroup`) references sico_productgroup (id)
)');

		$connection->executeStatement('
create table IF NOT EXISTS sico_productgroup_s_articles
(
	`productgroup_id` BINARY(16) not null,
	`product_id`      BINARY(16) not null,
	`created_at` DATETIME(3) NOT NULL,
	`updated_at` DATETIME(3) NULL,
	`product_version_id` BINARY(16) not null,
	primary key (productgroup_id, product_id),
	constraint FK_F90AEA575BC5238A
	foreign key (productgroup_id) references sico_productgroup (id)
)
        ');

		$connection->executeStatement('
create table IF NOT EXISTS sico_credit_plus_payment
(
	`id` BINARY(16) NOT NULL primary key,
	`order_id`      BINARY(16),
	`url`			VARCHAR(255),
	`gen_timestamp`   int(11),
	`orderNumber`	varchar(255),
	`created_at` DATETIME(3) NOT NULL,
	`updated_at` DATETIME(3) NULL,
	`token` varchar(255),

	FOREIGN KEY(`order_id`) references `order`(id)
)
        ');
        $oColumResult = $connection->executeQuery('SHOW COLUMNS FROM product WHERE Field LIKE "prodgroups"');
        if($oColumResult->rowCount() == 0){
            try{
                $this->updateInheritance($connection,'product','prodgroups');
            } catch(DBALException $e){
                //Columns is propably already defined
                print($e->getMessage());
            }
        }

    }

    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
    }
}
