<?php declare(strict_types=1);

namespace SicoCreditPlus\Migration;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Exception;
use Shopware\Core\Framework\Migration\MigrationStep;

class Migration1627286458CreateVersioning extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1627286458;
    }

    public function update(Connection $connection): void
    {
		$sql = 'SHOW COLUMNS FROM sico_credit_plus_payment';
		$resultStatement = $connection->executeQuery($sql);
		$fields = $resultStatement->fetchAllAssociative();
		$bHasBackUrl = false;
		foreach($fields as $field){
			if($field['Field'] === 'version_id'){
				$bHasBackUrl = true;
			}
		}

		if(!$bHasBackUrl){
			$sql = 'ALTER TABLE sico_credit_plus_payment ADD COLUMN version_id BINARY(16) NOT NULL AFTER `id`,
  ADD PRIMARY KEY `id_version_id`(`id`,`version_id`),
  DROP INDEX `PRIMARY`';
			//  ADD PRIMARY KEY `id_version_id`(`id`,`version_id`),
			//  DROP INDEX `PRIMARY`
			try{
				$connection->executeStatement($sql);
			} catch(Exception $e){

			}
		}
    }

    public function updateDestructive(Connection $connection): void
    {

    }
}
