<?php declare(strict_types=1);

namespace SicoCreditPlus\Migration;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Exception as DBALException;
use Shopware\Core\Framework\Migration\MigrationStep;

class Migration1627391245AddForeignKeyCascade extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1627391245;
    }

    public function update(Connection $connection): void
    {
        $sDatabase = $connection->getDatabase();

		$oTableFK =$connection->executeQuery('SELECT * FROM information_schema.TABLE_CONSTRAINTS
WHERE information_schema.TABLE_CONSTRAINTS.CONSTRAINT_TYPE = \'FOREIGN KEY\' AND
TABLE_SCHEMA = \''.$sDatabase.'\' AND TABLE_NAME = \'sico_credit_plus_payment\';');
		$aTableFKs = $oTableFK->fetchAllAssociative();//According doku i should use this function
		$bHasForeignKey = false;
        $sForeignKeyName = '';
        if(count($aTableFKs) == 1){
            $bHasForeignKey = true;
            $sForeignKeyName = $aTableFKs[0]['CONSTRAINT_NAME'];
        } else {
            foreach($aTableFKs as $aTableFK){
                if($aTableFK['CONSTRAINT_NAME'] === 'sico_credit_plus_payment_ibfk_1'){
                    $bHasForeignKey = true;
                    $sForeignKeyName = 'sico_credit_plus_payment_ibfk_1';
                }
            }
        }

		$oTableIndex = $connection->executeQuery('SHOW INDEXES IN sico_credit_plus_payment');
		$aTableIndexes = $oTableIndex->fetchAllAssociative();//According doku i should use this function
		$bHasOrderIdKey = false;
		foreach($aTableIndexes as $aTableIndex){
			if($aTableIndex['Key_name'] == 'order_id' || $aTableIndex['Column_name'] == 'order_id'){
				$bHasOrderIdKey = true;
			}
		}
		$bConstraintDropped = false;
		if($bHasForeignKey){
			$bConstraintDropped = true;
            try{
			    $connection->executeStatement('alter table sico_credit_plus_payment drop foreign key `'.$sForeignKeyName.'`;');
            } catch(DBALException $e){
                $this->migrationLog([
                    'message' => $e->getMessage(),
                    'aTableFKs' => $aTableFKs
                ],'Error in drop foregin key');
            }
		}
		if($bHasOrderIdKey){
			$bConstraintDropped = true;
            try{
                $connection->executeStatement('alter table sico_credit_plus_payment drop index `order_id`;');
            } catch(DBALException $e){
                $this->migrationLog([
                    'message' => $e->getMessage(),
                    'TableIndexes' => $aTableIndexes
                ],'Error in drop index');
            }
		}

		if($bConstraintDropped){
			$connection->executeStatement('alter table sico_credit_plus_payment
	add constraint sico_credit_plus_payment_ibfk_1
		foreign key (order_id) references `order` (id)
			on delete cascade;');
		}

    }

    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
    }

    public function migrationLog($var,$constant = ''){
        if(true){
            file_put_contents(dirname(__FILE__).'/migration_log.txt','['.date('c').'] '.$constant.' '.var_export($var,true)."\n",FILE_APPEND);
        }
    }
}
