<?php declare(strict_types=1);

namespace SicoCreditPlus\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;
use Shopware\Core\Framework\Uuid\Uuid;

class Migration1646835442addSaleschannelToProdgroup extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1646835442;
    }

    public function update(Connection $connection): void
    {
        $sql = 'SHOW COLUMNS FROM sico_productgroup';
        $resultStatement = $connection->executeQuery($sql);
        $fields = $resultStatement->fetchAllAssociative();
        $bHasSalesChannel = false;
        foreach($fields as $field){
            if($field['Field'] === 'saleschannel'){
                $bHasSalesChannel = true;
            }
        }
        if(!$bHasSalesChannel){
            //$sql = "ALTER TABLE sico_productgroup ADD COLUMN sales_channel_id";
        }

        $sql = "CREATE TABLE IF NOT EXISTS sico_productgroup_sales_channel(
    id BINARY(16) not null,
    productgroup_id binary(16)  not null,
    sales_channel_id binary(16) not null,
    PRIMARY KEY (`id`),
    KEY `idx.sico_productgroup_sales_channel.productgroup_id`(`productgroup_id`),
    KEY `idx.sico_productgroup_sales_channel.sales_channel_id`(`sales_channel_id`),
    CONSTRAINT `fk.sico_productgroup_sales_channel.productgroup_id` FOREIGN KEY (`productgroup_id`)
        REFERENCES `sico_productgroup` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT `fk.sico_productgroup_sales_channel.sales_channel_id` FOREIGN KEY (`sales_channel_id`)
        REFERENCES `sales_channel` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
    )ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
        $connection->executeStatement($sql);

        $sql = 'SELECT id FROM sico_productgroup';
        $aProductGroupResults = $connection->executeQuery($sql)->fetchAllAssociative();
        $sql = 'SELECT id FROM sales_channel';
        $aSalesChannels = $connection->executeQuery($sql)->fetchAllAssociative();
        $insertStmt = $connection->prepare('INSERT INTO `sico_productgroup_sales_channel`(`id`,`productgroup_id`,`sales_channel_id`) VALUE (?,?,?)');
        foreach($aProductGroupResults as $aProductGroupResult){
            foreach($aSalesChannels as $aSalesChannel){
                $newId = Uuid::randomBytes();
                $insertStmt->executeStatement([$newId,$aProductGroupResult['id'],$aSalesChannel['id']]);
            }
        }

    }

    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
    }
}
