<?php declare(strict_types=1);

namespace SicoCreditPlus\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;

class Migration1648212539prodgrouSalesChannelMissingFields extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1648212539;
    }

    public function update(Connection $connection): void
    {
        $sql = 'SHOW COLUMNS FROM sico_productgroup_sales_channel';
        $resultStatement = $connection->executeQuery($sql);
        $fields = $resultStatement->fetchAllAssociative();
        $bHasCreatedAt = false;
        $bHasUpdateAt = false;
        foreach($fields as $field){
            if($field['Field'] === 'created_at'){
                $bHasCreatedAt = true;
            }
            if($field['Field'] === 'updated_at'){
                $bHasUpdateAt = true;
            }
        }
        if(!$bHasCreatedAt){
            $connection->executeStatement('ALTER TABLE `sico_productgroup_sales_channel` ADD COLUMN `created_at` DATETIME(3) NOT NULL DEFAULT "2022-03-25 14:00:00.000"');
        }
        if(!$bHasUpdateAt){
            $connection->executeStatement('ALTER TABLE `sico_productgroup_sales_channel` ADD COLUMN `updated_at` DATETIME(3) NULL');
        }
    }

    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
    }
}
