<?php declare(strict_types=1);

namespace SicoCreditPlus\Migration;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Exception as DBALException;
use Shopware\Core\Framework\Migration\MigrationStep;

class Migration1719228161CalculatedRates extends MigrationStep
{
	public function getCreationTimestamp(): int
	{
		return 1719228161;
	}

	/**
	 * Creates the new table for calculated financing months.
	 * Adds field to product table.
	 *
	 * @param Connection $connection
	 * @return void
	 * @throws DBALException
	 */
	public function update(Connection $connection): void
	{
		$connection->executeStatement("
		CREATE TABLE IF NOT EXISTS sico_credit_plus_calculated_rate (
			`id` BINARY(16) NOT NULL,
			`product_id` BINARY (16),
			`product_version_id` BINARY (16),
			`sico_sales_channel_id` BINARY (16),
			`sico_min_months` int(11),
			`sico_min_months_interest_rate` double,
			`sico_min_months_rate` double,
			`sico_max_months` int(11),
			`sico_max_months_interest_rate` double,
			`sico_max_months_rate` double,
			`sico_absolute_min_rate_months` int(11),
			`sico_absolute_min_rate_interest_rate` double,
			`sico_absolute_min_rate_rate` double,
			`sico_fictional_min_rate_months` int(11),
			`sico_fictional_min_rate_interest_rate` double,
			`sico_fictional_min_rate_rate` double,
			`sico_currency_id` BINARY(16),
			`sico_calculation_finished` tinyint(1) NULL DEFAULT NULL,
			`created_at` DATETIME(3) NOT NULL,
			`updated_at` DATETIME(3) NULL,
			PRIMARY KEY(`id`),
			FOREIGN KEY (`sico_currency_id`) references currency (id),
			FOREIGN KEY (`sico_sales_channel_id`) references sales_channel (id),
			FOREIGN KEY (`product_id`) references product (id)
		);
		");
		try {
			$connection->executeStatement("
				ALTER TABLE product ADD COLUMN sicoCreditPlusCalculatedRates BINARY (16) DEFAULT id;
			");
		} catch (\Exception $e) {
			try {
				// Same as above: MySQL 5.7 does not support default values from other fields
				$connection->executeStatement("
					ALTER TABLE `product` ADD COLUMN sicoCreditPlusCalculatedRates BINARY(16) NULL DEFAULT NULL;
				");
				$connection->executeStatement("
					CREATE TRIGGER product_before_insert_creditplus BEFORE INSERT ON `product` FOR EACH ROW
					BEGIN
						IF NEW.sicoCreditPlusCalculatedRates IS NULL THEN
							SET NEW.sicoCreditPlusCalculatedRates = NEW.id;
						END IF;
					END;
				");
				$connection->executeStatement("UPDATE product SET sicoCreditPlusCalculatedRates = id WHERE sicoCreditPlusCalculatedRates IS NULL;");
			} catch (\Exception $oInnerException) {
				// Maybe the trigger failed to be created, this is as far as we can go.
				if ( $oInnerException instanceof DBALException ) {
					throw $oInnerException;
				}
			}
			// Ignore if field already exists
		}
	}

	public function updateDestructive(Connection $connection): void
	{
		// No destructive updates exists
	}
}
