import template from './contract-status-rule.html.twig';

Shopware.Component.extend('contract-status-rule','sw-condition-base',{
    template,
    computed: {
        selectValues(){
            return [
                {
                    label: 'Accepted',
                    value: 24
                },
                {
                    label: 'Referred',
                    value: 20
                },
                {
                    label: 'Declined',
                    value: 93
                }
            ]
        },
        contractStatus:{
            get: function(){
                this.ensureValueExist();

                if(this.condition.value.creditPlusStatus == null) {
                    this.condition.value.creditPlusStatus = 20;
                }

                return this.condition.value.creditPlusStatus;
            },
            set: function(contractStatus) {
                this.ensureValueExist();
                //this.condition.value = {...this.condition.value,contractStatus};
                if(this.condition.value != null){
                    this.condition.value.creditPlusStatus = contractStatus;
                }
            }
        }
    }
});
