import { ACTION, GROUP } from '../../constant/credit-plus-dispatched-action.constant';

const { Component } = Shopware;

Component.override('sw-flow-sequence-action', {
	computed: {
		modalName() {
			if (this.selectedAction === ACTION.DISPATCH) {
				return 'sw-flow-sequence-action-creditplus-dispatched';
			}
			return this.$super('modalName');
		},
		actionDescription() {
			const actionDescriptionList = this.$super('actionDescription');
			return {
				...actionDescriptionList,
				[ACTION.DISPATCH]: this.$tc('credit-plus-dispatched-action.descriptionCreditPlusDispatched')
			};
		}
	},
	methods: {
		getActionTitle(actionName) {
			if (actionName === ACTION.DISPATCH) {
				return {
					value: actionName,
					icon: 'regular-tag',
					label: this.$tc('credit-plus-dispatched-action.titleCreditPlusDispatched'),
					group: GROUP
				};
			}

			return this.$super('getActionTitle', actionName);
		}
	}
});
