import template from './cp-offered-options.html.twig';

const { Component, Mixin } = Shopware;
const { Criteria } = Shopware.Data;

Shopware.Component.register('cp-offered-options',{
    template:template,
    data(){
        return {
            offeredOptions:null
        }
    },
    inject:['repositoryFactory'],
    computed:{
        getOfferedOptionCriteria(){
            var criteria = new Criteria();
            criteria.addAssociation('sicoProdgroup');
            return criteria;
        },
        getOfferedOptionRepository(){
            return this.repositoryFactory.create('sico_offered_option');
        },
        getOfferedOptionColumns(){
            return [
                {
                    property:'sicoMonths',
                    label: 'Monate',//this.$tc('sw-product.list.columnName')
                    inlineEdit:'number',
                    allowResize: true,
                    primary: true
                },{
                    property:'sicoInterest',
                    label: 'Effektiver Jahreszins',//this.$tc('sw-product.list.columnName')
                    inlineEdit:'number',
                    allowResize: true,
                    primary: true
                }, {
                    property:'sicoProdcode',
                    label: 'Produkt Code',//this.$tc('sw-product.list.columnName')
                    inlineEdit:'string',
                    allowResize: true,
                    primary: true
                },{
                    property:'sicoActive',
                    label: 'Aktiv',//this.$tc('sw-product.list.columnName')
                    inlineEdit:'boolean',
                    allowResize: true,
                    primary: true
                },{
                    property:'sicoRatefactor',
                    label: 'Ratenfaktor',//this.$tc('sw-product.list.columnName')
                    inlineEdit:'number',
                    allowResize: true,
                    primary: true
                },{
                    property:'sicoProdgroup.sicoName',
                    label:'Produktgruppe',
                    allowResize:true
                }
            ];
        }
    },
    methods:{
        onComponentCreation(){
            this.getOfferedOptionRepository.search(this.getOfferedOptionCriteria,Shopware.Context.api).then((res) => {
                this.offeredOptions = res;
            });
        }
    },
    created(){
        this.onComponentCreation();
    }
});
