import template from './prodgroup-detail.html.twig';
import prodGroupState from './state';
const { mapPageErrors, mapState, mapGetters } = Shopware.Component.getComponentHelper();

const { Component, Mixin } = Shopware;
const { Criteria } = Shopware.Data;

Shopware.Component.register('cp-prodgroup-detail',{
    template: template,
    data(){
        return {
            //prodgroup: null,
            isLoading:false,
            isSaveSuccessful: false
        }
    },
    props: {
        prodgroupId: {
            type: String,
            required: false,
            default: null
        }
    },
    inject: ['repositoryFactory', 'cacheApiService'],
    methods:{
        createdComponent() {
            this.isLoading = true;
            let prodgroupId = this.prodgroupId;
            if(prodgroupId !== null){
                this.prodgroupRepository.get(prodgroupId,Shopware.Context.api,this.prodgroupCriteria).then((res) => {
                    Shopware.State.commit('cpProdGroupState/setProdgroup', res);
                    Shopware.State.commit('cpProdGroupState/setProdgroupId',prodgroupId);
                });
                this.offeredOptionsRepository.search(this.offeredOptionsCriteria(prodgroupId),Shopware.Context.api).then((res) => {
                    Shopware.State.commit('cpProdGroupState/setOfferedOptions',res);
                    this.isLoading = false;
                });
            }
            else {
                Shopware.State.commit('cpProdGroupState/setProdgroup', this.prodgroupRepository.create(Shopware.Context.api));
                this.isLoading = false;
            }

        },
        offeredOptionsCriteria(prodgroupId){
            let criteria = new Criteria();
            criteria.addFilter(Criteria.equals('sicoProdgroupId', prodgroupId));
            criteria.addSorting(Criteria.sort('sicoMonths', 'ASC'));
            return criteria;
        },
        onSave(){
            this.isLoading = true;
            this.prodgroupRepository.save(this.prodgroup,Shopware.Context.api).then(() => {
                this.isLoading = false;
                this.isSaveSuccessful = true;
                //this.$router.push({name:'sico.creditplus.prodgroupDetail', params:{id:this.prodgroup.id}});
                Shopware.State.commit('cpProdGroupState/setProdgroupId',this.prodgroup.id);
                window.setTimeout(()=>{this.isSaveSuccessful = false},2000);
                this.cacheApiService.clear().then();
            });

        },
        tooltipSave() {
            //const systemKey = this.$device.getSystemKey();

            return {
                message: `Save Button`,
                appearance: 'light'
            };
        },
    },
    computed:{
        prodgroupRepository() {
            return this.repositoryFactory.create('sico_productgroup');
        },
        prodgroupCriteria(){
            let criteria = new Criteria();
            // criteria.addAssociation('product');
            criteria.addAssociation('prodgroupSalesChannel');
            criteria.addAssociation('dynamicProductGroup');
            return criteria;
        },
        offeredOptionsRepository(){
            return this.repositoryFactory.create('sico_offered_option');
        },
        ...mapState('cpProdGroupState',['prodgroup'])
    },
    beforeCreate(){
        Shopware.State.registerModule('cpProdGroupState', prodGroupState);
    },
    created(){
        this.createdComponent();
    },
    beforeDestroy() {
        Shopware.State.unregisterModule('cpProdGroupState');
    },
});
