import template from './cp-productgroup-detail-article.html.twig';

const { mapPageErrors, mapState, mapGetters } = Shopware.Component.getComponentHelper();

Shopware.Component.register('cp-productgroup-detail-article',{
    template:template,
    computed: {
        ...mapState('cpProdGroupState', [
            'prodgroup'
        ]),
        productColumns(){
            return [{
                property: 'name',
                label: 'Name',
            }, {
                property: 'productNumber',
                naturalSorting: true,
                label: 'Produkt Nummer',
                align: 'right',
                allowResize: true
            }, {
                property: 'manufacturer.name',
                label: 'Hersteller Name',
                allowResize: true
            }, {
                property: 'active',
                label: 'Aktiv',
                inlineEdit: 'boolean',
                allowResize: true,
                align: 'center'
            }];
        }
    }
});
