import template from './cp-productgroup-detail-base.html.twig';

const { Component, Mixin, Context } = Shopware;
const { Criteria,EntityCollection } = Shopware.Data;
const { mapPageErrors, mapState, mapGetters } = Shopware.Component.getComponentHelper();

Shopware.Component.register('cp-productgroup-detail-base',{
    template: template,
    data(){
        return {
            //prodgroup: null,
            isLoading:false,
            isSaveSuccessful: false,
            sortBy: 'sicoInterest',
            sortDirection: 'DESC',
            salesChannels:[],
            dynamicProductGroups:[],
        }
    },
    mixins: [
        Mixin.getByName('listing')
    ],
    inject: ['repositoryFactory'],
    computed:{
        ...mapState('cpProdGroupState',['prodgroupId','prodgroup','offeredOptions']),
        columns(){
            return [
                {property: 'sicoMonths',label:'Monate',rawData:true,inlineEdit:'number',sortable:true},
                {property: 'sicoInterest',label:'Effektiver Jahreszins',rawData:true,inlineEdit:'number',sortable:true},
                {property: 'sicoProdcode',label:'Produkt Code',rawData:true,inlineEdit:'string',sortable:true},
                {property: 'sicoActive',label:'Aktiv',rawData:true,inlineEdit:'boolean',sortable:true},
                {property: 'sicoRatefactor',label:'Ratenfaktor',rawData:true,inlineEdit:'number',sortable:true},
            ];
        },
        offeredOptionRepository(){
            return this.repositoryFactory.create('sico_offered_option');
        },
        salesChannelRepository(){
            return this.repositoryFactory.create('sales_channel');
        },
        dynamicProductGroupRepository(){
            return this.repositoryFactory.create('product_stream');
        },
        salesChannelIds: {
            get(){
                if(!this.prodgroup){
                    return [];
                }
                if(!this.prodgroup.prodgroupSalesChannel){
                    return [];
                }
                return this.prodgroup.prodgroupSalesChannel.map((salesChannel) => {
                    return salesChannel.salesChannelId;
                })
            },
            set(salesChannelsIds){
                salesChannelsIds = salesChannelsIds || [];
                const { deleted, added } = this.getChangeset(salesChannelsIds);
                if (this.prodgroup.isNew()) {
                    this.handleLocalMode(deleted, added);
                    return;
                }
                this.handleWithRepository(deleted, added);
            },
        },
        prodgroupSalesChannelRepository(){
            if(this.prodgroup){
                return this.repositoryFactory.create(
                    this.prodgroup.prodgroupSalesChannel.entity,
                    this.prodgroup.prodgroupSalesChannel.source,
                );
            }
            return null;
        },
        salesChannelCriteria() {
            const salesChannelCriteria = new Criteria(1, 500);
            salesChannelCriteria.addSorting(Criteria.sort('name', 'ASC', this.naturalSorting));

            return salesChannelCriteria;
        },
        dynamicProductGroupCriteria() {
            const dynamicProductGroupCriteria = new Criteria(1, 500);
            dynamicProductGroupCriteria.addSorting(Criteria.sort('name', 'ASC', this.naturalSorting));

            return dynamicProductGroupCriteria;
        },
    },
    created() {
        this.createdComponent();
    },
    methods:{
        createdComponent() {

            this.salesChannelRepository
                .search(this.salesChannelCriteria)
                .then(searchresult => {
                    this.salesChannels = searchresult;
                });
            this.dynamicProductGroupRepository
                .search(this.dynamicProductGroupCriteria)
                .then(searchresult => {
                    this.dynamicProductGroups = searchresult
                });
        },
        addRate(){
            this.isLoading = true;
            let offeredOption = this.offeredOptionRepository.create(Shopware.Context.api);
            offeredOption.sicoMonths = 6;
            offeredOption.sicoInterest = 0.0;
            offeredOption.sicoProdcode = "Standard";
            offeredOption.sicoActive = false;
            offeredOption.sicoRatefactor = -1;
            offeredOption.sicoProdgroup = this.prodgroup;
            offeredOption.sicoProdgroupId = this.prodgroup.id;
            this.offeredOptionRepository.save(offeredOption,Shopware.Context.api).then(() => {
                Shopware.State.commit('cpProdGroupState/addOfferedOption', offeredOption);
                this.isLoading = false;
                this.isSaveSuccessful = true;
                window.setTimeout(()=>this.isSaveSuccessful = false,2000);
            })

        },
        removeRate(item){
            this.offeredOptionRepository.delete(item.id,Shopware.Context.api).then(() => {
                Shopware.State.commit('cpProdGroupState/deleteOfferedOption',item);
            });
        },
        updateRate(item){
            //console.log(item);
            this.offeredOptionRepository.save(item,Shopware.Context.api).then(() => {});
        },
        getList(){
            /*
            this.isLoading = true;
            const criteria = new Criteria(this.);
            this.getOfferedOptionRepository.search()
            */
        },
        // --------------------------- Multi Select Field ----------------------------
        getChangeset(salesChannelsIds) {
            const deleted = [];
            const added = [];
            salesChannelsIds.forEach((id) => {
                const foundSalesChannel = this.prodgroup.prodgroupSalesChannel.find((salesChannel) => {
                    return salesChannel.salesChannelId === id;
                });

                if(!foundSalesChannel){
                    added.push(id);
                }
            });
            this.prodgroup.prodgroupSalesChannel.forEach((salesChannel) => {
                if (!salesChannelsIds.includes(salesChannel.salesChannelId)) {
                    deleted.push(salesChannel.salesChannelId);
                }
            });
            return { deleted, added };
        },
        getAssociationBySalesChannelId(salesChannelId) {
            return this.prodgroup.prodgroupSalesChannel.find((association) => {
                return association.salesChannelId === salesChannelId;
            });
        },
        handleLocalMode(deleted, added) {
            deleted.forEach((deletedId) => {
                const collectionEntry = this.getAssociationBySalesChannelId(deletedId);
                this.prodgroup.prodgroupSalesChannel.remove(collectionEntry.id);
            });
            added.forEach((newId) => {
                const newAssociation = this.prodgroupSalesChannelRepository.create(this.prodgroup.prodgroupSalesChannel.context);

                newAssociation.salesChannelId = newId;
                newAssociation.productgroupId = this.prodgroup.id;
                this.prodgroup.prodgroupSalesChannel.add(newAssociation);
            });
        },
        handleWithRepository(deleted,added){
            deleted.forEach((deletedId) => {
                const collectionEntry = this.getAssociationBySalesChannelId(deletedId);
                this.prodgroup.prodgroupSalesChannel.remove(collectionEntry.id);
            });
            added.forEach((newId) => {
                const newAssociation = this.prodgroupSalesChannelRepository.create(this.prodgroup.prodgroupSalesChannel.context);

                newAssociation.salesChannelId = newId;
                newAssociation.productgroupId = this.prodgroup.id;
                this.prodgroup.prodgroupSalesChannel.add(newAssociation);
            });
        },
        setIds(salesChannels){
            this.salesChannels=salesChannels;
            //this.prodgroup.prodgroupSalesChannel = salesChannels;
        }
    }
});
