import Plugin from 'src/plugin-system/plugin.class';
import HttpClient from 'src/service/http-client.service';
import PseudoModalUtil from 'src/utility/modal-extension/pseudo-modal.util';
import PageLoadingIndicatorUtil from 'src/utility/loading-indicator/page-loading-indicator.util';

export default class RatetableModalPlugin extends Plugin{
    init(){
        this.el.addEventListener('click',this._getModal.bind(this));
        this._client = new HttpClient();
    }

    _getModal(event){
        PageLoadingIndicatorUtil.create();
        const parent = this.el.closest('.rate-table--modal-mode');
        const productId = parent.dataset.articleId;
        this._client.abort();
        this._client.get('/modal/creditplus/ratetable/'+productId,(content) => {this._openModal(content)})
    }

    _openModal(response){
        PageLoadingIndicatorUtil.remove();
        const pseudoModal = new PseudoModalUtil(response);
        pseudoModal.open(this._onOpen.bind(this, pseudoModal));
        const modal = pseudoModal.getModal();
        modal.classList.add('cp-ratetable-plugin');
    }

    _onOpen(pseudoModal){
        window.PluginManager.initializePlugins();
    }
}
