<?php
/**
 * Created by PhpStorm.
 * @author mihovil.bubnjar
 * @date 10.07.2024
 * @time 12:05
 */

namespace SicoCreditPlus\ScheduledTasks;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\Framework\MessageQueue\ScheduledTask\ScheduledTaskHandler;
use SicoCreditPlus\Components\SicoCreditPlusLogger;

class RateCalculatorResetHandler extends ScheduledTaskHandler
{
	protected ?SicoCreditPlusLogger $oCreditPlusLogger = null;
	protected ?Connection $oConnection = null;

	public function __construct(EntityRepository $scheduledTaskRepository, SicoCreditPlusLogger $oCreditPlusLogger, Connection $oConnection)
	{
		parent::__construct($scheduledTaskRepository);
		if ( !$this->oCreditPlusLogger ) {
			$this->oCreditPlusLogger = $oCreditPlusLogger;
		}
		if ( !$this->oConnection ) {
			$this->oConnection = $oConnection;
		}
	}

	/**
	 * @inheritDoc
	 */
	public static function getHandledMessages(): iterable
	{
		return [ RateCalculatorResetTask::class ];
	}

	public function run(): void
	{
		$this->oConnection->executeStatement("UPDATE sico_credit_plus_calculated_rate SET sico_calculation_finished = 0 WHERE sico_calculation_finished = 1");
		$oQuery = $this->oConnection->executeQuery("SELECT sico_sales_channel_id, COUNT(*) num_affected FROM sico_credit_plus_calculated_rate GROUP BY sico_sales_channel_id");
		$aResult = $oQuery->fetchAllAssociative();
		foreach ( $aResult as $aSalesChannelInformation ) {
			$this->oCreditPlusLogger->log(false, 'Rate calculation restarted for Sales Channel', ['SalesChannel.id' => bin2hex($aSalesChannelInformation['sico_sales_channel_id']), 'affected' => $aSalesChannelInformation['num_affected']], bin2hex($aSalesChannelInformation['sico_sales_channel_id']));
		}
		if ( !$aResult ) {
			$this->oCreditPlusLogger->log(false, 'No calculated rates were found.', []);
		}
	}
}
