<?php declare(strict_types=1);
/**
 * Created by PhpStorm.
 * User: Philipp.Holzmann
 * Date: 03.01.2020
 * Time: 15:25
 */

namespace SicoCreditPlus\Service;

use Shopware\Core\Checkout\Order\Aggregate\OrderTransaction\OrderTransactionCollection;
use Shopware\Core\Checkout\Payment\Cart\AsyncPaymentTransactionStruct;
use Shopware\Core\Checkout\Payment\Cart\PaymentHandler\AsynchronousPaymentHandlerInterface;
use Shopware\Core\Checkout\Payment\Cart\PaymentHandler\SynchronousPaymentHandlerInterface;
use Shopware\Core\Checkout\Payment\Cart\SyncPaymentTransactionStruct;
use Shopware\Core\Checkout\Payment\Exception\AsyncPaymentFinalizeException;
use Shopware\Core\Checkout\Payment\Exception\AsyncPaymentProcessException;
use Shopware\Core\Checkout\Payment\Exception\CustomerCanceledAsyncPaymentException;
use Shopware\Core\Checkout\Payment\Exception\SyncPaymentProcessException;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\Validation\DataBag\RequestDataBag;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Core\System\SystemConfig\SystemConfigService;
use SicoCreditPlus\Components\SicoCreditPlusHelper;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Shopware\Storefront\Framework\Routing\Router;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

class CreditPlusPayment implements AsynchronousPaymentHandlerInterface {

	/**
	 * @var SicoCreditPlusHelper
	 */
	private $creditPlusHelper;

	public function __construct(SicoCreditPlusHelper $creditPlusHelper)
	{
		$this->creditPlusHelper = $creditPlusHelper;
	}

	public function pay(AsyncPaymentTransactionStruct $transaction, RequestDataBag $dataBag, SalesChannelContext $salesChannelContext): RedirectResponse
	{
			$sReturnURL = $transaction->getReturnUrl();
			return new RedirectResponse($sReturnURL);
	}

	public function finalize(AsyncPaymentTransactionStruct $transaction, Request $request, SalesChannelContext $salesChannelContext): void
	{
		$this->creditPlusHelper->setSalesChannelContext($salesChannelContext);
		$this->creditPlusHelper->setContext($salesChannelContext->getContext());

		$sTargetUrl = $this->creditPlusHelper->getTargetURLForFinishingPayment($transaction->getOrderTransaction()->getId(),$salesChannelContext->getSalesChannelId());
		$oOrder = $transaction->getOrder();

		$oTransactionEntity = $transaction->getOrderTransaction();
		$oOrderTransactionCollection = new OrderTransactionCollection();
		$oOrderTransactionCollection->add($oTransactionEntity);
		$oOrder->setTransactions($oOrderTransactionCollection);
		$this->creditPlusHelper->sendAdditionalMessageMail($salesChannelContext,$oOrder,$sTargetUrl);
	}

}
