<?php
/**
 * Created by PhpStorm.
 * User: Philipp.Holzmann
 * Date: 05.02.2020
 * Time: 13:35
 */

namespace SicoCreditPlus\Subscriber;

use Shopware\Core\Checkout\Payment\PaymentMethodEntity;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\EqualsFilter;
use SicoCreditPlus\Components\SicoCreditPlusHelper;
use SicoCreditPlus\Core\Content\CreditPlusPayment\CreditPlusPaymentEntity;
use SicoCreditPlus\Service\CreditPlusPayment;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Shopware\Core\Framework\Struct\ArrayEntity;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Contracts\Translation\TranslatorInterface;
use Shopware\Storefront\Page\Checkout\Finish\CheckoutFinishPageLoadedEvent;
use Shopware\Storefront\Framework\Routing\Router;
use Shopware\Core\System\SystemConfig\SystemConfigService;

class CheckoutFinishSubscriber implements EventSubscriberInterface{

	/** @var TranslatorInterface  */
	protected $oSnippetService;

	/** @var Router  */
	protected $oRouter;

	/** @var SystemConfigService  */
	protected $oSystemConfigService;

	/** @var EntityRepository  */
	protected $oPaymentMethod;

	/** @var SicoCreditPlusHelper  */
	protected $oCPHelper;

    /** @var EntityRepository */
    protected $oCpPaymentRepo;

    /** @var EntityRepository */
    private $oOrderRepo;

	public function __construct(TranslatorInterface $snippetService,
								UrlGeneratorInterface $router,
								SystemConfigService $systemConfigService,
                                EntityRepository $paymentMethod,
								SicoCreditPlusHelper $oCPHelper,
                                EntityRepository $oCpPaymentRepo,
                                EntityRepository $oOrderRepo)
	{
		$this->oSnippetService = $snippetService;
		$this->oRouter = $router;
		$this->oSystemConfigService = $systemConfigService;
		$this->oPaymentMethod = $paymentMethod;
		$this->oCPHelper = $oCPHelper;
        $this->oCpPaymentRepo = $oCpPaymentRepo;
        $this->oOrderRepo = $oOrderRepo;
	}

	/**
	 * Returns an array of event names this subscriber wants to listen to.
	 *
	 * The array keys are event names and the value can be:
	 *
	 * * The method name to call (priority defaults to 0)
	 * * An array composed of the method name to call and the priority
	 * * An array of arrays composed of the method names to call and respective
	 *   priorities, or 0 if unset
	 *
	 * For instance:
	 *
	 * * array('eventName' => 'methodName')
	 * * array('eventName' => array('methodName', $priority))
	 * * array('eventName' => array(array('methodName1', $priority), array('methodName2'))
	 *
	 * @return array The event names to listen to
	 */
	public static function getSubscribedEvents()
	{
		return [CheckoutFinishPageLoadedEvent::class => 'onFinishPage'];
	}


	public function onFinishPage(CheckoutFinishPageLoadedEvent $event){
        $this->onCheckoutPlacedEvent($event);
		$oOrder = $event->getPage()->getOrder();
		$oOrderTransaction = $oOrder->getTransactions()->first();
		$sTransactionId = $oOrderTransaction->getId();
		$sSalesChannelId = $event->getSalesChannelContext()->getSalesChannelId();

		$sPaymentId = $oOrderTransaction->getPaymentMethodId();
		$this->oCPHelper->setContext($event->getContext());
		/** @var PaymentMethodEntity $oPaymentEntity */
		$oPaymentEntity = $this->oPaymentMethod->search(
			(new Criteria())->addFilter(
				new EqualsFilter('handlerIdentifier',CreditPlusPayment::class)
			),$event->getContext())->first();
		$bPaymentCp = $sPaymentId == $oPaymentEntity->getId();
		if($bPaymentCp){
			$sPayNowUrl = $this->getSelectedViewUrl($sTransactionId, $sSalesChannelId);
			$sCancelUrl = $this->oRouter->generate('frontend.creditplus.trigger.cancelandreorder',[
				'sOrderTransactionId' => $sTransactionId
			]);


			if($this->oSystemConfigService->get('SicoCreditPlus.config.sTransactionMode',$sSalesChannelId) == 'inorder'){
				$sSicoFinishText = $this->oSnippetService->trans('sicoCreditplus.checkout.FinishTextToPayment');
				$oContract = $this->oCPHelper->getContractData($sSalesChannelId,$oOrder);

				if($oContract){
					if ( in_array(((int)$oContract->state), array(20,92,93)) ) {
						$sSicoFinishText = $this->oSnippetService->trans('sicoCreditplus.checkout.FinishTextWaitInorder');
					}
					$sPaymentState = $this->oCPHelper->getCreditPlusPaymentState($oContract->state, $oContract->finallyApproved, $oContract->deliveryDone, $oContract->informationRequest);
					$this->oCPHelper->setPaymentStatus($oOrder, $sPaymentState);
				}
			} else {
				$sSicoFinishText = $this->oSnippetService->trans('sicoCreditplus.checkout.FinishText');
			}
			$sSicoFinishText = str_replace('http://retry.me/',$sPayNowUrl,$sSicoFinishText);
			$sSicoFinishText = str_replace('http://replace.me/',$sCancelUrl,$sSicoFinishText);
		}
		else{
			$sSicoFinishText = '';
		}

		$oArrEntity = new ArrayEntity([
			'sicoFinishText' => $sSicoFinishText
		]);
		$event->getPage()->addExtension('SicoCreditPlus',$oArrEntity);
	}

	protected function getSelectedViewUrl(string $sOrderTransactionId,string $sSalesChannelId, $oPathDetail = Router::ABSOLUTE_PATH){
		$selectedView = $this->oSystemConfigService->get('SicoCreditPlus.config.sCPShownAs',$sSalesChannelId);
		switch($selectedView){
			case 'popup':
				$url = $this->oRouter->generate('frontend.creditplus.trigger.popup',['orderTransactionId' => $sOrderTransactionId],$oPathDetail);
				break;
			case 'iframe':
				$url = $this->oRouter->generate('frontend.creditplus.trigger.iframe',['orderTransactionId' => $sOrderTransactionId],$oPathDetail);
				break;
			case 'new_window':
				$url = $this->oRouter->generate('frontend.creditplus.trigger.new-window',['orderTransactionId' => $sOrderTransactionId],$oPathDetail);
				break;
			default:
				$url = $this->oRouter->generate('frontend.creditplus.popup',['orderTransactionId' => $sOrderTransactionId],$oPathDetail);
		}
		return $url;
	}

    public function onCheckoutPlacedEvent(CheckoutFinishPageLoadedEvent $event):void{
        $orderId = $event->getPage()->getOrder()->getId();//$event->getOrder()->getId();
        $cpDealerOrderNumber = $event->getRequest()->getSession()->get('cpDealerOrderNumber');
        if($cpDealerOrderNumber != null) {
            $customFields = $event->getPage()->getOrder()->getCustomFields();
            $customFields['cpDealerOrderNumber'] = $cpDealerOrderNumber;
            $this->oOrderRepo->update([[
                'id' => $orderId,
                'customFields' => $customFields
            ]], $event->getContext());

            $oCpPaymentColl = $this->oCpPaymentRepo->search((new Criteria())->addFilter(new EqualsFilter('orderNumber', $cpDealerOrderNumber)), $event->getContext());
            /** @var CreditPlusPaymentEntity $oCpPaymentEntity */
            $oCpPaymentEntity = $oCpPaymentColl->first();
            $this->oCpPaymentRepo->update([[
                'id' => $oCpPaymentEntity->getId(),
                'orderId' => $event->getPage()->getOrder()->getId(),
                'versionId' => $event->getPage()->getOrder()->getVersionId()
            ]], $event->getContext());
        }
    }
}
