<?php
/**
 * This file is part of the SinkaCom CreditPlus Module Package.
 *
 * @link      http://www.sinkacom.de/
 * @copyright (C) SinkaCom AG 2015-2019
 * @version   OXID eShop CE
 */
/**
 * Created by PhpStorm.
 * @author Mihovil.Bubnjar
 * @date 04.01.2019
 * @time 15:16
 */
namespace Sinkacom\CreditPlusModule\Component;

use Exception;
use Sinkacom\CreditPlusModule\Lib\CreditPlusHelper\AbstractShopLogger;
use Sinkacom\CreditPlusModule\Model\LogEntry;

class LoggerComponent extends AbstractShopLogger {

	/**
	 * Write SoapClient Request-Info
	 * to Log-File
	 *
	 * @param string $sToday Timestamp for log file entry
	 * @param bool $bError Whether or not this file is prefixed with error
	 * @param string $sFunctionName Which function has been called
	 * @param string $sContent Content to log
	 *
	 * @throws Exception
	 */
	public function writeLastRequestInfo( $sToday = '', $bError = false, $sFunctionName = '', $sContent = '' ) {
		$oLog = $this->createLogEntry($sToday, $bError, $sFunctionName, $sContent, 'request');
		$oLog->save();
	}

	/**
	 * Write SoapClient Request-Info
	 * to Log-File
	 *
	 * @param string $sToday Timestamp for log file entry
	 * @param bool $bError Whether or not to use error prefix in file name
	 * @param string $sFunctionName Which function was called
	 * @param string $sContent Content to log
	 *
	 * @throws Exception
	 */
	public function writeLastResponseInfo( $sToday = '', $bError = false, $sFunctionName = '', $sContent = '' ) {
		$oLog = $this->createLogEntry($sToday, $bError, $sFunctionName, $sContent, 'response');
		$oLog->save();
	}

	/**
	 * Write Request-Information-Data
	 * to Log-File
	 *
	 * @param string $sToday Timestamp for log file entry
	 * @param string $sFunctionName The called API function name (e.g. getContracts)
	 * @param string[] $aArgumentData The arguments passed to $sFunctionName
	 * @param bool $bError true, if logged event is an error
	 *
	 * @throws Exception
	 */
	public function writeRequestInformation( $sToday = '', $bError = false, $sFunctionName = '', $aArgumentData = array() ) {
		$oLog = $this->createLogEntry($sToday, $bError, $sFunctionName, $aArgumentData, 'info');
		$oLog->save();
	}

	/**
	 * @param string $sToday
	 * @param bool $bError
	 * @param string $sFunctionName
	 * @param string[]|string $aLogData
	 * @param string $sType
	 *
	 * @return LogEntry|null
	 */
	protected function createLogEntry( $sToday, $bError, $sFunctionName, $aLogData, $sType ) {
		/** @var LogEntry $oLog */
		$oLog = null;
		try {
			$oLog = oxNew(LogEntry::class);
			$oLog->setId();
			$oLog->sccp_logentry__sclogtime = new \OxidEsales\Eshop\Core\Field($sToday, \OxidEsales\Eshop\Core\Field::T_RAW);
			$oLog->sccp_logentry__scerror = new \OxidEsales\Eshop\Core\Field($bError, \OxidEsales\Eshop\Core\Field::T_RAW);
			$oLog->sccp_logentry__sccalledfunction = new \OxidEsales\Eshop\Core\Field($sFunctionName, \OxidEsales\Eshop\Core\Field::T_RAW);
			$oLog->sccp_logentry__sclogentry = new \OxidEsales\Eshop\Core\Field($aLogData, \OxidEsales\Eshop\Core\Field::T_RAW);
			$oLog->sccp_logentry__sctype = new \OxidEsales\Eshop\Core\Field($sType, \OxidEsales\Eshop\Core\Field::T_RAW);
		} catch ( \OxidEsales\Eshop\Core\Exception\SystemComponentException $oEx ) {
			// Class not found, doesn't happen
		}
		return $oLog;
	}
}
