<?php
/**
 * This file is part of the SinkaCom CreditPlus Module Package.
 *
 * @link      http://www.sinkacom.de/
 * @copyright (C) SinkaCom AG 2015-2019
 * @version   OXID eShop CE
 */
/**
 * Created by PhpStorm.
 * User: sinkacom
 * Date: 08.04.16
 * Time: 11:41
 */

namespace Sinkacom\CreditPlusModule\Controller;

use OxidEsales\Eshop\Core\Exception\SystemComponentException;
use OxidEsales\Eshop\Core as ESCore;
use Sinkacom\CreditPlusModule\Component\CommonsComponent;

class AccountOrder extends AccountOrder_parent {

	public function render() {
		$sReturn = parent::render();
		/** @var CommonsComponent $oCommons */
		$oCommons = oxNew('Sinkacom\CreditPlusModule\Component\CommonsComponent');
		$oCommons->addFinancingStyles();

		/** @var ESCore\Theme $oTheme */
		try {
			$oTheme = oxNew(ESCore\Theme::class);
		} catch ( SystemComponentException $oEx ) {
			// Class oxTheme not found, can't be flow
			$this->_aViewData['bFlowTheme'] = false;
			return $sReturn;
		}

		$oTheme->load($oTheme->getActiveThemeId());
		$bFlowTheme = false;
		if ( $oTheme->getId() == 'flow' ) {
			$bFlowTheme = true;
		} else {
			if ( $oParentTheme = $oTheme->getParent() ) {
				$bFlowTheme = ($oParentTheme->getId() == 'flow');
			}
		}
		$this->_aViewData['bFlowTheme'] = $bFlowTheme;
		return $sReturn;
	}

	/**
	 * @param \Sinkacom\CreditPlusModule\Model\Order $oOrder
	 * @return string
	 */
	public function getSccpPayNowURL( $oOrder ) {
		$sReturn = '';
		if ( $oOrder ) {
			/** @var RestartOrder $oRestartOrder */
			$oRestartOrder = oxNew(RestartOrder::class);

			if ( !$oRestartOrder->isFinished($oOrder) ) {
				if ( $oOrder->oxorder__oxpaymenttype->value == 'sccp_financing' ) {
					$oConfig = $this->getConfig();
					$sShownAs = $oConfig->getShopConfVar('sCPShownAs', null, 'module:sccp');
					if ( $sShownAs == 'popup' ) {
						$sReturn = $this->getViewConfig()->getSelfActionLink().'cl=sinkacom_creditplusmodule_trigger&fnc=showSccpPopup&don='.$oOrder->oxorder__oxtransid->value.'&oxid='.$oOrder->oxorder__oxid->value;
					} elseif ($sShownAs == 'iframe') {
						$sReturn = $this->getViewConfig()->getSelfActionLink().'cl=sinkacom_creditplusmodule_trigger&fnc=showSccpIframe&don='.$oOrder->oxorder__oxtransid->value.'&oxid='.$oOrder->oxorder__oxid->value;
					}
				}

			}
		}
		return $sReturn;
	}

	/**
	 * @param \Sinkacom\CreditPlusModule\Model\Order $oOrder
	 * @return string
	 */
	public function getSccpCancelURL( $oOrder ) {
		$sReturn = '';
		if ( $oOrder ) {
			/** @var RestartOrder $oRestartOrder */
			$oRestartOrder = oxNew(RestartOrder::class);

			if ( $oRestartOrder->isInStateForRerun($oOrder) ) {
				if ( $oOrder->oxorder__oxpaymenttype->value == 'sccp_financing' ) {
					$sReturn = $this->getViewConfig()->getSelfActionLink().'cl=sinkacom_creditplusmodule_restartorder&don='.$oOrder->oxorder__oxtransid->value.'&oxid='.$oOrder->oxorder__oxid->value;
				}
			}
		}
		return $sReturn;
	}

}
