<?php
/**
 * This file is part of the SinkaCom CreditPlus Module Package.
 *
 * @link      http://www.sinkacom.de/
 * @copyright (C) SinkaCom AG 2015-2019
 * @version   OXID eShop CE
 */

/**
 * Created by PhpStorm.
 * @author Mihovil.Bubnjar
 * @date 02.01.2019
 * @time 14:30
 */
namespace Sinkacom\CreditPlusModule\Controller\Admin;
use Exception;
use OxidEsales\Eshop\Application\Controller\Admin\AdminController;
use Sinkacom\CreditPlusModule\Model as SCModel;
use OxidEsales\Eshop\Application\Model as ESModel;
use OxidEsales\Eshop\Core as ESCore;

class CpCronjobMail extends AdminController {

	protected $_sThisTemplate = 'sccp_cpcronjob_mail.tpl';
	protected $_iTimeInterval = 86400;

	/**
	 * @return bool true for execmail if called by cronjob
	 */
	protected function _authorize() {
		// This is a thing only set in the running code, we don't expect a request to ever come from such an IP address
		if ( $_SERVER['REMOTE_ADDR'] === '127.225.19.86' ) {
			$oRequest = ESCore\Registry::getRequest();
			if ( $oRequest->getRequestParameter('fnc') == 'execmail' ) {
				return true;
			}
		}
		return parent::_authorize();
	}

	public function execmail() {
		if ( !$this->isGoodExecuteTime() ) {
			return;
		}
		$oConfig = $this->getConfig();
		$iLastRunTime = (int) $oConfig->getShopConfVar('iCronLastRunMail', null, 'module:sccp');
		$sTime = gmdate('Y-m-d H:i:s', $iLastRunTime);
		$iTime = time();
		$oList = null;
		$oOrderList = null;
		try {
			/** @var ESCore\Model\ListModel|SCModel\RequestQueue[] $oList */
			$oList = oxNew(ESCore\Model\ListModel::class);
			$oList->init(SCModel\RequestQueue::class);
			$oList->selectString("SELECT * FROM sccp_requestqueue WHERE ((scexecutiondate >= '$sTime') AND (scalreadyexecuted = 1) AND (scretryround = 4))");
			if ( $oList->count() > 0 ) {
				$aOrderIDs = array();
				foreach ( $oList as $oRQ ) {
					$aOrderIDs[] = $oRQ->sccp_requestqueue__scorderid->value;
				}
				/** @var ESCore\Model\ListModel|ESModel\Order[] $oOrderList */
				$oOrderList = oxNew(ESCore\Model\ListModel::class);
				$oOrderList->init(ESModel\Order::class);
				$oOrderList->selectString("SELECT * FROM oxorder WHERE oxid IN ('".implode("','",$aOrderIDs)."')");
				if ( $oOrderList->count() > 0 ) {
					$this->sendFailedMail($oOrderList);
					$aResult = array();
					if ( $oOrderList->count() > 1 ) {
						$aResult[] = 'Es wurden '.$oOrderList->count().' Bestellungen als fehlgeschlagen gemeldet.';
					} else {
						$aResult[] = 'Es wurde '.$oOrderList->count().' Bestellung als fehlgeschlagen gemeldet.';
					}
					$aResult[] = 'Cronjob ausgeführt am '.date('Y-m-d').' um '.date('H:i:s').'.';
					$oConfig->saveShopConfVar('arr', 'aCronLastResultMail', $aResult, null, 'module:sccp');
				}
			}

		} catch ( Exception $oEx ) {

		}
		$oConfig->saveShopConfVar('str', 'iCronLastRunMail', $iTime, null, 'module:sccp');
		$oConfig->saveShopConfVar('str', 'iCronNextRunMail', $iTime+$this->_iTimeInterval, null, 'module:sccp');
	}


	/**
	 * @param ESCore\Model\ListModel|ESModel\Order $oOrders
	 *
	 */
	public function sendFailedMail( $oOrders ) {
		$oConfig = $this->getConfig();
		/** @var ESCore\Email $oMail */
		$oMail = oxNew(ESCore\Email::class);
		/** @var ESCore\UtilsView $oUtilsView */
		$oUtilsView = ESCore\Registry::get(ESCore\UtilsView::class);
		/** @var \Smarty $oSmarty */
		$oSmarty = $oUtilsView->getSmarty();
		/** @var ESCore\Language $oLang */
		$oLang = ESCore\Registry::getLang();
		$sTitle = $oLang->translateString('SCCP_MAIL_TITLE_RETRY_ERRORS');
		// OXID treats "template_dir" as array, so we add our module folder to get the templates found.
		if ( is_array($oSmarty->template_dir) ) {
			$oSmarty->template_dir[] = dirname(__FILE__,3).'/application/views/';
			$oSmarty->template_dir[] = $oConfig->getTemplateDir();
		}
		$oMail->setCharSet('utf-8');
		$oMail->setSubject($sTitle);
		$oSmarty->assign('title', $sTitle);
		$oSmarty->assign('oOrders', $oOrders);
		$oSmarty->assign('oViewConf', $this->getViewConfig());
		$oSmarty->assign('oEmailView', $oMail);
		$sFileHtml = 'email/html/sc_requeue_error.tpl';
		$sFileText = 'email/plain/sc_requeue_error.tpl';
		$sType = 'html';
		$sHtmlText = '';
		$sTextText = '';
		$oShop = $oConfig->getActiveShop();
		$sRecipient = $oShop->oxshops__oxowneremail->value;
		$sRecipientName = $oShop->oxshops__oxname->value;
		$oSmarty->assign('sRecipientName', $sRecipientName);
		$sFrom = $oConfig->getActiveShop()->oxshops__oxowneremail->value;
		$sFromName = $oConfig->getActiveShop()->oxshops__oxname->value;
		try {
			$sHtmlText = $oSmarty->fetch($sFileHtml);
			if ( trim($sHtmlText) == '' ) {
				$sType = 'text';
			}
		} catch ( Exception $oEx) {
			$sType = 'text';
		}
		try {
			$sTextText = $oSmarty->fetch($sFileText);
		} catch ( Exception $oEx) {
			// No Text mode available
		}
		if ( $sType == 'html' ) {
			$oMail->setBody($sHtmlText);
			$oMail->setAltBody($sTextText);
		} else {
			$oMail->setBody($sTextText);
		}
		if ( ($sTextText || $sHtmlText) && $sRecipient && $sRecipientName ) {
			$oMail->setRecipient($sRecipient, $sRecipientName);
			$oMail->setFrom($sFrom, $sFromName);
			$oMail->send();
		}
	}

	/**
	 * @return bool true if time is greater than next run time
	 */
	protected function isGoodExecuteTime() {
		$iTime = time();
		$oConfig = $this->getConfig();
		$iNextRunTime = (int) $oConfig->getShopConfVar('iCronNextRunMail', null, 'module:sccp');
		return ($iTime > $iNextRunTime);
	}

	public function render() {
		$sTemplate = parent::render();

		return $sTemplate;
	}
}
