<?php
/**
 * This file is part of the SinkaCom CreditPlus Module Package.
 *
 * @link      http://www.sinkacom.de/
 * @copyright (C) SinkaCom AG 2015-2019
 * @version   OXID eShop CE
 */

/**
 * Created by PhpStorm.
 * @author Mihovil.Bubnjar
 * @date 02.01.2019
 * @time 14:30
 */
namespace Sinkacom\CreditPlusModule\Controller\Admin;
use OxidEsales\Eshop\Application\Controller\Admin\AdminController;

use Sinkacom\CreditPlusModule\Component\CommonsComponent;
use Sinkacom\CreditPlusModule\Model as SCModel;
use OxidEsales\Eshop\Core as ESCore;
use OxidEsales\Eshop\Application\Model as ESModel;
use Exception;

class CpCronjobMain extends AdminController {

	protected $_sThisTemplate = 'sccp_cpcronjob_main.tpl';
	protected $_iTimeInterval = 300;

	protected function _authorize() {
		// This is a thing only set in the running code, we don't expect a request to ever come from such an IP address
		if ( $_SERVER['REMOTE_ADDR'] === '127.225.19.86' ) {
			$oRequest = ESCore\Registry::getRequest();
			if ( $oRequest->getRequestParameter('fnc') == 'execmain' ) {
				return true;
			}
		}
		return parent::_authorize();
	}

	public function execmain() {
		if ( !$this->isGoodExecuteTime() ) {
			return;
		}
		$oConfig = $this->getConfig();
		/** @var CommonsComponent $oCmpCommons */
		$oCmpCommons = oxNew( CommonsComponent::class);
		$iTime = time();
		$sTime = date('Y-m-d H:i:s', $iTime);
		$aSuccess = array(
			'total' => 0,
			'successInRun' => array(
				1 => 0,
				2 => 0,
				3 => 0,
				4 => 0,
			),
			'requeued' => 0,
			'givenUp' => 0,
		);
		try {
			/** @var ESCore\Model\ListModel|SCModel\RequestQueue[] $oList */
			$oList = oxNew(ESCore\Model\ListModel::class);
			$oList->init(SCModel\RequestQueue::class);
			$oList->selectString("SELECT * FROM sccp_requestqueue WHERE ((scexecutiondate <= '$sTime') AND (scalreadyexecuted = 0)) ");
			if ( $oList->count() > 0 ) {
				/** @var string[] $aOrderIDs */
				$aOrderIDs = array();
				/** @var SCModel\RequestQueue[] $aRQs */
				$aRQs = array();
				foreach ( $oList as $oRQ ) {
					$aOrderIDs[] = $oRQ->sccp_requestqueue__scorderid->value;
					$aRQs[$oRQ->sccp_requestqueue__scorderid->value] = $oRQ;
					$aSuccess['total']++;
				}
				/** @var ESCore\Model\ListModel|SCModel\Order[] $oOrderList */
				$oOrderList = oxNew(ESCore\Model\ListModel::class);
				$oOrderList->init(ESModel\Order::class);
				$sOrderIDs = '"'.implode('","', $aOrderIDs).'"';
				$oOrderList->selectString("SELECT * FROM oxorder WHERE oxid IN ($sOrderIDs)");
				$aTransactionIDs = array();
				foreach ( $oOrderList as $oOrder ) {
					$aTransactionIDs[] = $oOrder->oxorder__oxtransid->value;
					$aTransactionIDs[] = $oOrder->oxorder__oxordernr->value;
				}
				$oCmpCommons->getContractDataMultiple($aTransactionIDs);
				foreach ( $oOrderList as $oOrder ) {
					try {
						$oRQ = isset($aRQs[$oOrder->oxorder__oxid->value])?$aRQs[$oOrder->oxorder__oxid->value]:null;
						$oCmpCommons->checkForUpdateMail($oOrder);
						if ( $oRQ ) {
							$oRQ->sccp_requestqueue__scalreadyexecuted->setValue(1);
							$oRQ->save();
							$aSuccess['successInRun'][$oRQ->sccp_requestqueue__scretryround->value]++;
						}
					} catch ( Exception $oEx ) {
						if ( $oRQ ) {
							if ( $oRQ->sccp_requestqueue__scretryround->value < 4 ) {
								$this->cloneQueue($oRQ);
								$aSuccess['requeued']++;
							} else {
								$aSuccess['givenUp']++;
							}
							$oRQ->sccp_requestqueue__scalreadyexecuted->setValue(1);
							$oRQ->save();
						}
					}
				}
			}
		} catch ( Exception $oEx ) {

		}
		$aReturn = array();
		if ( $aSuccess['total'] ) {
			$aReturn[] = 'Ausgeführt gesamt: '.$aSuccess['total'];
		}
		for ( $iRun = 1 ; $iRun <= count($aSuccess['successInRun']) ; $iRun++ ) {
			if ( $aSuccess['successInRun'][$iRun] ) {
				$aReturn[] = 'Erfolgreich im Lauf '.$iRun.': '.$aSuccess['successInRun'][$iRun];
			}
		}
		if ( $aSuccess['requeued'] ) {
			$aReturn[] = 'Wieder eingereiht: '.$aSuccess['requeued'];
		}
		if ( $aSuccess['givenUp'] ) {
			$aReturn[] = 'Aufgegeben: '.$aSuccess['givenUp'];
		}
		if ( $aReturn ) {
			$aReturn[] = 'Gelaufen am '.date('d.m.Y').' um '.date('H:i:s').'.';
		}
		$oConfig->saveShopConfVar('str', 'iCronLastRunMain', $iTime, null, 'module:sccp');
		$iNextRun = $iTime+$this->_iTimeInterval;
		$oConfig->saveShopConfVar('str', 'iCronNextRunMain', $iNextRun, null, 'module:sccp');
		if ( $aReturn ) {
			$oConfig->saveShopConfVar('arr', 'aCronLastResultMain', $aReturn, null, 'module:sccp');
		}
	}

	/**
	 * @param SCModel\RequestQueue $oRQ
	 *
	 * @throws Exception
	 */
	protected function cloneQueue( $oRQ ) {
		/** @var SCModel\RequestQueue $oNewQueue */
		$oNewQueue = oxNew( SCModel\RequestQueue::class );
		$oNewQueue->setId();
		// 40-80 minutes
		$iSeconds = rand(2400, 4800);
		// The interval should always succeed
		$sNextDate = date('Y-m-d H:i:s', time()+$iSeconds);
		$oNewQueue->assign(array(
			'scorderid' => $oRQ->sccp_requestqueue__scorderid->value,
			'scexecutiondate' => $sNextDate,
			'scalreadyexecuted' => 0,
			'scretryround' => ((int)$oRQ->sccp_requestqueue__scretryround->value)+1,
		));
		$oNewQueue->save();
	}

	/**
	 * @return bool true if time is greater than next run time
	 */
	protected function isGoodExecuteTime() {
		$iTime = time();
		$oConfig = $this->getConfig();
		$iNextRunTime = (int) $oConfig->getShopConfVar('iCronNextRunMain', null, 'module:sccp');
		return ($iTime > $iNextRunTime);
	}

	public function render() {
		$sTemplate = parent::render();

		return $sTemplate;
	}
}
