<?php
/**
 * This file is part of the SinkaCom CreditPlus Module Package.
 *
 * @link      http://www.sinkacom.de/
 * @copyright (C) SinkaCom AG 2015-2019
 * @version   OXID eShop CE
 */
/**
 * Created by PhpStorm.
 * User: sinkacom
 * Date: 08.04.16
 * Time: 15:28
 */

namespace Sinkacom\CreditPlusModule\Controller\Admin;

use OxidEsales\Eshop\Application\Controller\Admin\AdminDetailsController;
use OxidEsales\Eshop\Core as ESCore;
use OxidEsales\Eshop\Application\Model as ESModel;
use Sinkacom\CreditPlusModule\Model as SCModel;

class CpExcludedArticlesDetail extends AdminDetailsController {

	protected $_sThisTemplate = 'sccp_cpexcluded_articles_detail.tpl';

	public function render() {
		$sReturn = parent::render();
		return $sReturn;
	}

	public function showFinancingOptions() {
		$oRequest = ESCore\Registry::getRequest();
		if ( $sArtNum = $oRequest->getRequestParameter('sArtNum') )  {
			try {
				$this->_aViewData['sArtNum'] = htmlspecialchars($sArtNum);
				$oDB = ESCore\DatabaseProvider::getDb(ESCore\DatabaseProvider::FETCH_MODE_ASSOC);
				$sArtNumDB = $oDB->quote($sArtNum);
				// SELECT oxid FROM oxartices WHERE oxartnum = $sArtNum to load the object afterwards
				/** @var ESModel\ArticleList $oArtList */
				$oArtList = oxNew(ESModel\ArticleList::class);
				$oArtList->selectString("SELECT * FROM oxarticles WHERE OXARTNUM = $sArtNumDB");
				$this->_aViewData['aFinancingOptions'] = array();
				if ( $oArtList->count() > 0 ) {
					$this->_aViewData['sMessage'] = 'SCCP_CPEXCLUDED_ARTICLES_FINANCING_OPTIONS';
					/** @var ESModel\Article|SCModel\Article $oArticle */
					foreach ( $oArtList as $oArticle ) {
						$dPrice = $oArticle->getPrice()->getBruttoPrice();
						/** @var ESModel\Payment $oPayment */
						$oPayment = oxNew(ESModel\Payment::class);
						$oPayment->load('sccp_financing');
						$dFromPrice = floatval($oPayment->oxpayments__oxfromamount->value);
						$dToPrice = floatval($oPayment->oxpayments__oxtoamount->value);
						if ( $dPrice < $dFromPrice ) {
							$aTableArticle = $oArticle->getSccpFinancingMonths(0.00, $dFromPrice);
						} elseif ( $dPrice > $dToPrice ) {
							$aTableArticle = $oArticle->getSccpFinancingMonths(0.00, $dToPrice);
						} else {
							$aTableArticle = $oArticle->getSccpFinancingMonths(0.00, $dPrice);
						}
						$this->_aViewData['aFinancingOptions'][$oArticle->oxarticles__oxartnum->value.': '.$oArticle->oxarticles__oxtitle->value] = $aTableArticle;
					}
				} else {
					$this->_aViewData['sMessage'] = 'SCCP_CPEXCLUDED_ARTICLES_FINANCING_OPTIONS_NO_ARTICLE_FOUND';
				}
			} catch ( ESCore\Exception\DatabaseConnectionException $oEx ) {
				// Database connection failed
				$this->_aViewData['sMessage'] = 'Database connection failed.';
				return;
			}
		} else {
			if ( $sArtNum === '' ) {
				$this->_aViewData['sMessage'] = 'SCCP_CPEXCLUDED_ARTICLES_FINANCING_OPTIONS_NO_ARTICLE_REQUESTED';
			}
		}
	}

	public function showList() {
		try {
			$oDB = ESCore\DatabaseProvider::getDb(ESCore\DatabaseProvider::FETCH_MODE_ASSOC);
			// SELECT product groups with assigned options without articles (= default groups)
			/** @var ESCore\Database\Adapter\Doctrine\ResultSet $oRes */
			$oRes = $oDB->select('
			SELECT pg.oxid oxid, pg.sccp_name sccp_name
			FROM sccp_prodgroup pg
			LEFT JOIN sccp_offered_option_prodgroup oopg ON oopg.sccp_prodgroup_id = pg.oxid
			LEFT JOIN sccp_offered_option oo ON oo.oxid = oopg.sccp_offered_option_id
			LEFT JOIN sccp_prodgroup_article pga ON pga.sccp_prodgroup_id = pg.oxid
			WHERE oo.sccp_active = 1
			AND pga.oxid IS NULL
			GROUP BY pg.oxid
			');
			$this->_aViewData['aArticles'] = array();
			if ( $oRes && $oRes->count() ) {
				$this->_aViewData['sMessage'] = 'SCCP_CPEXCLUDED_ARTICLES_DEFAULT_GROUP_ACTIVE';
				$this->_aViewData['sDefaultGroups'] = '<ul class="sccp-default-groups">';
				for ( $oRes->MoveFirst() ; !$oRes->EOF ; $oRes->MoveNext() ) {
					$sGroupOxid = $oRes->fields['oxid'];
					$sGroupName = $oRes->fields['sccp_name'];
					$this->_aViewData['sDefaultGroups'] .= "<li class='sccp-group-$sGroupOxid'>$sGroupName</li>";
				}
				$this->_aViewData['sDefaultGroups'] .= '</ul>';
			} else {
				$sSQL = '
					SELECT a.OXID oxid, a.OXTITLE oxtitle, a.OXARTNUM oxartnum, a.OXACTIVE oxactive
					FROM oxarticles a
					LEFT JOIN sccp_prodgroup_article pga ON pga.oxartid = a.OXID
					WHERE pga.oxid IS NULL';

				// display variants or not ?
				if ( !$this->getConfig()->getConfigParam('blVariantsSelection') ) {
					$sSQL .= " AND a.oxparentid = '' ";
				}

				$oRes = $oDB->select($sSQL);

				if ( $oRes && $oRes->count() ) {
					$this->_aViewData['sMessage'] = 'SCCP_CPEXCLUDED_ARTICLES_FOLLOWING_ARTICLES_MISSING';
					while ( !$oRes->EOF ) {
						$aArticle = $oRes->fields;
						$this->_aViewData['aArticles'][] = $aArticle;
						$oRes->fetchRow();
					}
				} else {
					$this->_aViewData['sMessage'] = 'SCCP_CPEXCLUDED_ARTICLES_ALL_ARTICLES_ASSIGNED';
				}
			}
		} catch ( ESCore\Exception\DatabaseConnectionException $oEx ) {
			// Database connection failed
			$this->_aViewData['sMessage'] = 'Database connection failed.';
			return;
		} catch ( ESCore\Exception\DatabaseErrorException $oEx ) {
			// Database query failed
			$this->_aViewData['sMessage'] = 'Database query failed.';
			return;
		}
	}
}

class_alias(CpExcludedArticlesDetail::class,'sccp_cpexcluded_articles_detail');
