<?php
/**
 * This file is part of the SinkaCom CreditPlus Module Package.
 *
 * @link      http://www.sinkacom.de/
 * @copyright (C) SinkaCom AG 2015-2019
 * @version   OXID eShop CE
 */

namespace Sinkacom\CreditPlusModule\Controller\Admin;

use OxidEsales\Eshop\Application\Controller\Admin\AdminDetailsController;
use OxidEsales\Eshop\Core\Registry;
use Sinkacom\CreditPlusModule\Model\LogEntry;

/**
 * Admin CreditPlus log details.
 * Displays a single log entry provided by main/list controllers
 * Admin Menu: Shop Settings -> CreditPlus Log -> Details.
 */
class CpLogViewDetails extends AdminDetailsController {

	protected $_sThisTemplate = 'sccp_cplogview_details.tpl';

	/**
	 * Executes parent method parent::render(), creates sccp_logentry, passes
	 * it's data to Smarty engine and returns name of template file
	 * "sccp_cplogview_details.tpl".
	 *
	 * @return string
	 */
	public function render() {
		$sReturn = parent::render();

		$oLog = null;
		/** @var LogEntry $oOrder */
		$oLog = oxNew(LogEntry::class);
		$oLang = Registry::getLang();

		$sOxid = $this->getEditObjectId();
		if ( $sOxid != "-1" && isset($sOxid) && ($oLog !== null) ) {
			// load object
			$oLog->load($sOxid);

			$this->_aViewData['edit'] = $oLog;
		}

		$this->_aViewData['alangs'] = $oLang->getLanguageNames();


		return $sReturn;
	}
}
