<?php
/**
 * This file is part of the SinkaCom CreditPlus Module Package.
 *
 * @link      http://www.sinkacom.de/
 * @copyright (C) SinkaCom AG 2015-2019
 * @version   OXID eShop CE
 */

namespace Sinkacom\CreditPlusModule\Controller\Admin;

use OxidEsales\Eshop\Application\Controller\Admin\AdminListController;
use OxidEsales\Eshop\Core\Registry;
use Sinkacom\CreditPlusModule\Model\LogEntry;

/**
 * Admin log list manager.
 * Performs collection and managing (such as filtering or deleting) function.
 * Admin Menu: Orders -> CreditPlus Log -> List.
 */
class CpLogViewList extends AdminListController {

	protected $_sThisTemplate = 'sccp_cplogview_list.tpl';

	/**
	 * Name of chosen object class (default null).
	 *
	 * @var string
	 */
	protected $_sListClass = LogEntry::class;

	/**
	 * Enable/disable sorting by DESC (SQL) (default: false - disable).
	 *
	 * @var bool
	 */
	protected $_blDesc = true;

	/**
	 * Default SQL sorting parameter (default null).
	 *
	 * @var string
	 */
	protected $_sDefSortField = "sclogtime";

	/**
	 * Executes parent method parent::render() and returns name of template
	 * file "order_list.tpl".
	 *
	 * @return string
	 */
	public function render() {
		$sReturn = parent::render();

		$aSearch = array(
			'oxorderarticles' => 'ARTID',
			'oxpayments' => 'PAYMENT'
		);
		$oRequest = Registry::getRequest();
		$sSearch = $oRequest->getRequestParameter("addsearch");
		$sSearchfld = $oRequest->getRequestParameter("addsearchfld");

		$this->_aViewData["addsearchfld"] = $sSearchfld?$sSearchfld:-1;
		$this->_aViewData["asearch"] = $aSearch;
		$this->_aViewData["addsearch"] = $sSearch;

		return $sReturn;
	}

	/**
	 * @return array
	 */
	public function getListFilter() {
		$bRewrite = false;
		if ( $this->_aListFilter === null ) {
			$bRewrite = true;
		}
		$aWhere = parent::getListFilter();
		if ( $bRewrite ) {
			if ( isset($aWhere['sccp_logentry']['scerror']) ) {
				$oLang = Registry::getLang();
				if ( $aWhere['sccp_logentry']['scerror'] === $oLang->translateString('GENERAL_YES') ) {
					$aWhere['sccp_logentry']['scerror'] = 1;
				} elseif ( $aWhere['sccp_logentry']['scerror'] === '1' ) {
					$aWhere['sccp_logentry']['scerror'] = 1;
				} elseif ( $aWhere['sccp_logentry']['scerror'] === '' ) {
					$aWhere['sccp_logentry']['scerror'] = '';
				} else {
					$aWhere['sccp_logentry']['scerror'] = 0;
				}
				$this->_aListFilter['sccp_logentry']['scerror'] = $aWhere['sccp_logentry']['scerror'];
			}
		}
		return $aWhere;
	}
}
