<?php
/**
 * This file is part of the SinkaCom CreditPlus Module Package.
 *
 * @link      http://www.sinkacom.de/
 * @copyright (C) SinkaCom AG 2015-2019
 * @version   OXID eShop CE
 */

namespace Sinkacom\CreditPlusModule\Controller\Admin;

use OxidEsales\Eshop\Application\Controller\Admin\ListComponentAjax;
use OxidEsales\Eshop\Core as ESCore;

/**
 * Class controls payment option assignment to product groups
 */

class CpOfferedOptionAjax extends ListComponentAjax {

	/**
	 * Columns array
	 *
	 * @var array
	 */
	protected $_aColumns = array(
		'container1' => array( // field , table, visible, multilanguage, ident
			array(
				'sccp_name',
				'sccp_prodgroup',
				1,
				0,
				0
			),
			array(
				'oxid',
				'sccp_prodgroup',
				0,
				0,
				0
			),
			array(
				'oxid',
				'sccp_prodgroup',
				0,
				0,
				1
			)
		),
		'container2' => array(
			array(
				'sccp_name',
				'sccp_prodgroup',
				1,
				0,
				0
			),
			array(
				'oxid',
				'sccp_prodgroup',
				0,
				0,
				0
			),
			array(
				'oxid',
				'sccp_offered_option_prodgroup',
				0,
				0,
				1
			),
			array(
				'oxid',
				'sccp_prodgroup',
				0,
				0,
				1
			)
		),
	);

	/**
	 * Returns SQL query for data to fetch
	 *
	 * @return string
	 */
	protected function _getQuery() {
		$sProdGroupTable = 'sccp_prodgroup';
		$sOO2PGView = 'sccp_offered_option_prodgroup';


		$sOxid =  ESCore\Registry::getRequest()->getRequestParameter('oxid');
		$sSynchOxid =  ESCore\Registry::getRequest()->getRequestParameter('synchoxid');

		try{
			$oDb = ESCore\DatabaseProvider::getDb();
			if ( $sOxid ) {
				$sOxid = $oDb->quote($sOxid);
			} else {
				$sSynchOxid = $oDb->quote($sSynchOxid);
			}
		} catch( ESCore\Exception\DatabaseConnectionException $e){
			// Database connection failed, do a preg_replace cleanup and surround with ' single quotes
			if ( $sOxid ) {
				$sOxid = "'".preg_replace('/[^a-z0-9]+/','', $sOxid)."'";
			} else {
				$sSynchOxid = "'".preg_replace('/[^a-z0-9]+/','', $sSynchOxid)."'";
			}
		}

		if ( $sOxid ) {
			// all categories article is in
			$sQAdd = " from $sOO2PGView left join $sProdGroupTable on $sProdGroupTable.oxid=$sOO2PGView.sccp_prodgroup_id ";
			$sQAdd .= " where $sOO2PGView.sccp_offered_option_id = ".$sOxid
				." and $sProdGroupTable.oxid is not null ";
		} else {
			$sQAdd = " from $sProdGroupTable where $sProdGroupTable.oxid not in ( ";
			$sQAdd .= " select $sProdGroupTable.oxid from $sOO2PGView "
				."left join $sProdGroupTable on $sProdGroupTable.oxid=$sOO2PGView.sccp_prodgroup_id";
			$sQAdd .= " where $sOO2PGView.sccp_offered_option_id = ".$sSynchOxid
				." and $sProdGroupTable.oxid is not null )";
		}

		return $sQAdd;
	}

	/**
	 * Removes option from chosen productgroup
	 */
	public function removePG() {
		$aRemovePG = $this->_getActionIds('sccp_prodgroup.oxid');

		$soxId = ESCore\Registry::getRequest()->getRequestParameter('oxid');
		try {
			$oDb = ESCore\DatabaseProvider::getDb();
			$soxId = $oDb->quote($soxId);
		} catch ( ESCore\Exception\DatabaseConnectionException $oEx ) {
			$soxId = "'".preg_replace('/[^a-z0-9]+/', '', $soxId)."'";
		}
		// adding
		if (  ESCore\Registry::getRequest()->getRequestParameter('all') ) {
			$sProdGroupTable = 'sccp_prodgroup';
			$aRemovePG = $this->_getAll($this->_addFilter("select {$sProdGroupTable}.oxid ".$this->_getQuery()));
		}

		// removing all
		if ( is_array($aRemovePG) && count($aRemovePG) ) {
			if ( isset($oDb) ) {
				$aRemovePG = $oDb->quoteArray($aRemovePG);
			} else {
				$aRemovePGNew = array();
				foreach ( $aRemovePG as $sRemovePG ) {
					$aRemovePGNew[] = "'".preg_replace('/[^a-z0-9]+/', '', $sRemovePG)."'";
				}
				$aRemovePG = $aRemovePGNew;
			}
			//TODO: Add version specific handling
			$sQ = "DELETE FROM sccp_offered_option_prodgroup WHERE sccp_offered_option_prodgroup.sccp_offered_option_id = "
				."$soxId AND "
				." sccp_offered_option_prodgroup.sccp_prodgroup_id IN (".implode(', ', $aRemovePG).')';
			if ( isset($oDb) ) {
				try {
					$oDb->execute($sQ);
				} catch ( ESCore\Exception\DatabaseErrorException $oEx ) {
					// Delete failed
				}
			} else {
				echo 'Database missing for Statement: '.$sQ;
			}
		}

		$this->resetContentCache();

	}

	/**
	 * Adds option to chosen productgroup
	 */
	public function addPG() {
		try{
			$oDb = ESCore\DatabaseProvider::getDb();
		} catch( ESCore\Exception\DatabaseConnectionException $e ) {
			// Database connection error
			return;
		}
		$aAddPG = $this->_getActionIds('sccp_prodgroup.oxid');
		$sSynchOxid =  ESCore\Registry::getRequest()->getRequestParameter('synchoxid');

		// adding
		if (  ESCore\Registry::getRequest()->getRequestParameter('all') ) {
			$sCategoriesTable = 'sccp_prodgroup';
			$aAddPG = $this->_getAll($this->_addFilter("select $sCategoriesTable.oxid ".$this->_getQuery()));
		}

		if ( isset($aAddPG) && is_array($aAddPG) ) {
			$oNew = oxNew(ESCore\Model\BaseModel::class);

			$oNew->init('sccp_offered_option_prodgroup');
			$oUtilsObject = ESCore\UtilsObject::getInstance();

			foreach ( $aAddPG as $sAdd ) {
				// check, if it's already in, then don't add it again
				$sSelect = "SELECT 1 FROM sccp_offered_option_prodgroup WHERE sccp_offered_option_prodgroup.sccp_prodgroup_id= "
					.$oDb->quote($sAdd)." AND sccp_offered_option_prodgroup.sccp_offered_option_id = ".$oDb->quote($sSynchOxid)." ";
				if ( $oDb->getOne($sSelect, false) ) {
					continue;
				}

				$oNew->setId($oUtilsObject->generateUId());
				$oNew->sccp_offered_option_prodgroup__sccp_offered_option_id = new ESCore\Field($sSynchOxid);
				$oNew->sccp_offered_option_prodgroup__sccp_prodgroup_id = new ESCore\Field($sAdd);

				$oNew->save();
			}
			$this->resetContentCache();
		}
	}
}

class_alias(CpOfferedOptionAjax::class,'sccp_cpoffered_option_ajax');
