<?php
/**
 * This file is part of the SinkaCom CreditPlus Module Package.
 *
 * @link      http://www.sinkacom.de/
 * @copyright (C) SinkaCom AG 2015-2019
 * @version   OXID eShop CE
 */
/**
 * Created by PhpStorm.
 * User: sinkacom
 * Date: 23.02.16
 * Time: 12:56
 */

namespace Sinkacom\CreditPlusModule\Controller\Admin;

use OxidEsales\Eshop\Application\Controller\Admin\AdminDetailsController;
use OxidEsales\Eshop\Application\Model as ESModel;
use OxidEsales\Eshop\Core as ESCore;
use Sinkacom\CreditPlusModule\Model as SCModel;
use Exception;

/**
 * Admin Product Group manager.
 * Displays different product groups and gives a possiblity to assign articles to them. One of them is marked as default and has no article assignments
 * Admin Menu: Orders -> CreditPlus Product Groups.
 */
class CpProductGroup extends AdminDetailsController
{

	protected $_sThisTemplate = 'sccp_cpproduct_group.tpl';
	/** @var ESModel\CategoryList $oCatTree */
	protected $oCatTree = null;

	/**
	 * @return string
	 */
	public function render()
	{
		$sReturn = parent::render();
		$oRequest = ESCore\Registry::getRequest();
		if ( $oRequest->getRequestParameter('aoc') == 1 ) {
			$this->_createCategoryTree("oCatTreeList");
			/** @var CpProductGroupAjax $oProductGroupAjax */
			$oProductGroupAjax = oxNew( CpProductGroupAjax::class);
			$this->_aViewData['oxajax'] = $oProductGroupAjax->getColumns();
			return 'popups/sccp_cpproduct_group.tpl';
		}
		/** @var ESCore\Model\ListModel $oList */
		$oList = oxNew(ESCore\Model\ListModel::class);
		$oList->init(SCModel\Prodgroup::class);

		$oList->selectString('SELECT * FROM sccp_prodgroup ORDER BY sccp_name ASC');

		/** @var ESCore\UtilsObject $oUtilsObject */
		$oUtilsObject = null;

		$oUtilsObject = ESCore\UtilsObject::getInstance();
		$sOxidBase = substr($oUtilsObject->generateUId(),0,3);

		$this->_aViewData['sOxidBase'] = $sOxidBase;
		$this->_aViewData['oList'] = $oList;

		return $sReturn;
	}

	public function save() {
		parent::save();
		$oRequest = ESCore\Registry::getRequest();
		$aPostedParams = $oRequest->getRequestParameter('editlist');
		try{
			foreach ( $aPostedParams as $sOXID => $aValues ) {
				/** @var SCModel\Prodgroup $oProdGroup */
				$oProdGroup = oxNew(SCModel\Prodgroup::class);
				$oProdGroup->load($sOXID);
				if (intval($aValues['delete']) === 1) {
					// Delete relation to other items, then item itself
					$oDB = ESCore\DatabaseProvider::getDb(ESCore\DatabaseProvider::FETCH_MODE_ASSOC);
					$sDeleteID = $oDB->quote($oProdGroup->getId());
					$oDB->execute("DELETE FROM sccp_offered_option_prodgroup WHERE sccp_prodgroup_id = $sDeleteID");
					$oDB->execute("DELETE FROM sccp_prodgroup_article WHERE sccp_prodgroup_id = $sDeleteID");
					$oProdGroup->delete();
				} else {
					$oProdGroup->setId($sOXID);
					$oProdGroup->assign($aValues);
					$oProdGroup->save();
				}
			}
			$this->_aViewData['sError'] = 200;
			$this->_aViewData['sErrorMessage'] = 'SCCP_FINANCING_PRODUCT_GROUPS_SAVED';
		} catch ( ESCore\Exception\DatabaseConnectionException $oEx ) {
			// Database connection failed
			$this->_aViewData['sError'] = 500;
			$this->_aViewData['sErrorMessage'] = 'Database connection failed';
		} catch ( ESCore\Exception\DatabaseErrorException $oEx ) {
			// Database query failed
			$this->_aViewData['sError'] = 500;
			$this->_aViewData['sErrorMessage'] = 'Database query failed';
		} catch ( Exception $oEx ) {
			// Database save failed
			$this->_aViewData['sError'] = 500;
			$this->_aViewData['sErrorMessage'] = 'Database save failed';
		}
	}

	/**
	 * Backport from 4.10.3
	 *
	 * @param string $sTplVarName
	 * @param string $sEditCatId
	 * @param bool $blForceNonCache
	 * @param null|string $iTreeShopId
	 *
	 * @return string
	 */
	protected function _createCategoryTree( $sTplVarName, $sEditCatId = '', $blForceNonCache = false, $iTreeShopId = null) {
		if ( method_exists('oxAdminDetails', '_createCategoryTree') ) {
			return parent::_createCategoryTree($sTplVarName, $sEditCatId, $blForceNonCache, $iTreeShopId);
		} else {
			// Fallback with backported code
			// caching category tree, to load it once, not many times
			if (!isset($this->oCatTree) || $blForceNonCache) {
				$this->oCatTree = oxNew(ESModel\CategoryList::class);
				$this->oCatTree->setShopID($iTreeShopId);

				// setting language
				/** @var ESModel\Category $oBase */
				$oBase = $this->oCatTree->getBaseObject();
				$oBase->setLanguage($this->_iEditLang);

				if ( method_exists($this->oCatTree, 'loadList') ) {
					$this->oCatTree->loadList();
				} elseif ( method_exists($this->oCatTree, 'buildList') ) {
					$this->oCatTree->buildList(true);
				}
			}
			// copying tree
			$oCatTree = $this->oCatTree;
			//removing current category
			if ($sEditCatId && isset($oCatTree[$sEditCatId])) {
				unset($oCatTree[$sEditCatId]);
			}
			// add first fake category for not assigned articles
			$oRoot = oxNew(ESModel\Category::class);
			$oRoot->oxcategories__oxtitle = new ESCore\Field('--');

			$oCatTree->assign(array_merge(array('' => $oRoot), $oCatTree->getArray()));

			// passing to view
			$this->_aViewData[$sTplVarName] = $oCatTree;
			return $oCatTree;
		}
	}
}

class_alias(CpProductGroup::class,'sccp_cpproduct_group');
