<?php
/**
 * This file is part of the SinkaCom CreditPlus Module Package.
 *
 * @link      http://www.sinkacom.de/
 * @copyright (C) SinkaCom AG 2015-2019
 * @version   OXID eShop CE
 */
/**
 * Created by PhpStorm.
 * User: sinkacom
 * Date: 09.03.16
 * Time: 14:22
 */

namespace Sinkacom\CreditPlusModule\Controller\Admin;

use OxidEsales\Eshop\Core\Registry;

class ModuleConfig extends ModuleConfig_parent {
	public function saveConfVars() {
		parent::saveConfVars();
		$oConfig = $this->getConfig();
		$oRequest = Registry::getRequest();
		$sShopId = $oConfig->getShopId();
		$sModuleId = $this->_getModuleForConfigVars();
		if ( $sModuleId == 'module:sccp' ) {
			foreach ($this->_aConfParams as $sType => $sParam) {
				$aConfVars = $oRequest->getRequestParameter($sParam);
				if (is_array($aConfVars)) {
					foreach ($aConfVars as $sName => $sValue) {
						if ( $sName == 'sMinRate' ) {
							$sValueNew = str_replace(',','.',$sValue);
							$fValue = floatval($sValueNew);
							if ( ($fValue < 25) || ($sValueNew != $sValue) ) {
								if ($fValue < 25) { $fValue = 25; }
								$sDbType = $this->_getDbConfigTypeName($sType);
								$oConfig->saveShopConfVar(
									$sDbType,
									$sName,
									$this->_serializeConfVar($sDbType, $sName, number_format($fValue,2,'.','')),
									$sShopId,
									$sModuleId
								);
							}
						}
					}
				}
			}
			if ( $aModuleVersions = $oConfig->getShopConfVar('aModuleVersions', $sShopId) ) {
				$sMetaData = @file_get_contents(dirname(dirname(__DIR__)).'/metadata.php');
				if ( $sMetaData ) {
					$aHits = [];
					if ( preg_match("/'version' => '([^']+)'/", $sMetaData, $aHits) ) {
						$sExpectedVersion = $aHits[1];
						if ( $aModuleVersions['sccp'] !== $sExpectedVersion ) {
							$aModuleVersions['sccp'] = $sExpectedVersion;
							$oConfig->saveShopConfVar('arr', 'aModuleVersions', $aModuleVersions, $sShopId);
							if ( method_exists($this, 'getContainer') ) {
								$oContainer = $this->getContainer();
								$oShopConfigurationDao = $oContainer->get(\OxidEsales\EshopCommunity\Internal\Framework\Module\Configuration\Bridge\ShopConfigurationDaoBridgeInterface::class);
								$oShopConfiguration = $oShopConfigurationDao->get();
								try {
									$oModuleConfig = $oShopConfiguration->getModuleConfiguration('sccp');
									$oModuleConfig->setVersion($sExpectedVersion);
									$oShopConfigurationDao->save($oShopConfiguration);
								} catch ( \Exception $oEx ) {
									// Module not found or something
								}
							}
						}
					}
				}
			}
		}
	}

	/**
	 * Convert metadata type to DB type.
	 *
	 * @param string $sType Metadata type.
	 *
	 * @return string
	 */
	private function _getDbConfigTypeName($sType)
	{
		$sDbType = $sType;
		if ($sType === 'password') {
			$sDbType = 'str';
		}

		return $sDbType;
	}
}

class_alias(ModuleConfig::class,'sccp_module_config');

