<?php
/**
 * This file is part of the SinkaCom CreditPlus Module Package.
 *
 * @link      http://www.sinkacom.de/
 * @copyright (C) SinkaCom AG 2015-2019
 * @version   OXID eShop CE
 */
/**
 * Created by PhpStorm.
 * User: mihovil.bubnjar
 * Date: 22.01.16
 * Time: 09:43
 */

namespace Sinkacom\CreditPlusModule\Controller\Admin;
use OxidEsales\Eshop\Application\Model as ESModel;
use Sinkacom\CreditPlusModule\Component\CommonsComponent;
use Sinkacom\CreditPlusModule\Lib\Controller\CreditPlusWebshopAPI;
use Sinkacom\CreditPlusModule\Model as SCModel;

class OrderMain extends OrderMain_parent {

	/**
	 * Sends order.
	 * Extended by commitDeliveryCPWebshop
	 * @see \OxidEsales\Eshop\Application\Controller\Admin\OrderMain::sendorder()
	 * @see CreditPlusWebshopAPI::commitDeliveryCPWebshop()
	 */
	public function sendorder()
	{
		$soxId = $this->getEditObjectId();
		/** @var SCModel\Order|ESModel\Order $oOrder */
		$oOrder = oxNew(ESModel\Order::class);
		if ($oOrder->load($soxId)) {
			parent::sendorder();

			include_once(dirname(dirname(dirname(__FILE__))) . '/Lib/createCreditOffer.php');
			$oConfig = $this->getConfig();
			/** @var CommonsComponent $oCmpCommons */
			$oCmpCommons = oxNew(CommonsComponent::class);
			$oWSApi = $oCmpCommons->getWebshopAPI();
			$oContractData = $oOrder->getContractData();

			$aData = array(
				'dealerNumber' => $oConfig->getShopConfVar('sCPDealer',null,'module:sccp'),
				'dealerOrderNumber' => $oContractData->dealerOrderNumber,
				'invoiceNumber' => $oOrder->oxorder__oxordernr->value,
				'invoicePrice' => $oOrder->oxorder__oxordersum->value,
				'deliveryDate' => date('c')
			);

			// $oCreditOfferResponse = $oWSApi->getContractsCPWebshop( array('dealerOrderNumber' => array($oOrder->oxorder__oxtransid->value) ) );
			$oWSApi->commitDeliveryCPWebshop( $aData );

		}
	}
}

class_alias(OrderMain::class,'sccp_order_main');
