<?php
/**
 * This file is part of the SinkaCom CreditPlus Module Package.
 *
 * @link      http://www.sinkacom.de/
 * @copyright (C) SinkaCom AG 2015-2019
 * @version   OXID eShop CE
 */
namespace Sinkacom\CreditPlusModule\Controller;
use Sinkacom\CreditPlusModule\Component\CommonsComponent;
use Sinkacom\CreditPlusModule\Model as SCModel;

class Details extends Details_parent {
	protected $_sCheapestRate = null;
	protected $_aFinancingTable = null;

	/**
	 * This function creates the financing options based on the products price
	 * and shows different monthly rates at the selected financing terms.
	 *
	 * The values are set by the backend (Extensions -> Modules -> Options)
	 * and the minimum value for the payment option with the id sccp_financing.
	 *
	 * If no valid months exist, the aMonthRows array will be empty.
	 *
	 * @return array('sFinancingDescription' => string, 'aMonthRows' => array(array('months' => float, 'interest' => string, 'totalAmount' => string, 'monthlyRate' => string)) The financing table description an rows.
	 */
	public function getFinancingTable() {
		if ( $this->_aFinancingTable !== null ) {
			return $this->_aFinancingTable;
		}
		/** @var CommonsComponent $oCommons */
		$oCommons = oxNew('Sinkacom\CreditPlusModule\Component\CommonsComponent');
		$oProduct = $this->getProduct();
		if ( $oProduct instanceof SCModel\Article ) {
			$this->_aFinancingTable = $oCommons->getFinancingTable($oProduct);
		}

		return $this->_aFinancingTable;
	}


	/**
	 * This function gives the lowest financing rate as a string, e.g. "Finance this for $ 14.33 per month over 48 months"
	 * @return string The text with the lowest rate
	 */
	public function getLowestFinancingRate() {
		if ( $this->_sCheapestRate !== null ) {
			return $this->_sCheapestRate;
		}
		/** @var CommonsComponent $oCommons */
		$oCommons = oxNew('Sinkacom\CreditPlusModule\Component\CommonsComponent');
		$oProduct = $this->getProduct();
		if ( $oProduct instanceof SCModel\Article ) {
			$this->_sCheapestRate = $oCommons->getLowestFinancingRate($oProduct);
		}
		return $this->_sCheapestRate;
	}

	public function render() {
		$sReturn = parent::render();
		/** @var CommonsComponent $oCommons */
		$oCommons = oxNew('Sinkacom\CreditPlusModule\Component\CommonsComponent');
		$oCommons->addFinancingStyles();
		return $sReturn;
	}

}

class_alias(Details::class,'sccp_details');

