<?php
/**
 * This file is part of the SinkaCom CreditPlus Module Package.
 *
 * @link      http://www.sinkacom.de/
 * @copyright (C) SinkaCom AG 2015-2019
 * @version   OXID eShop CE
 */
namespace Sinkacom\CreditPlusModule\Controller;

use OxidEsales\Eshop\Core as ESCore;
use OxidEsales\Eshop\Application\Model as ESModel;

class Order extends Order_parent {
	protected $_sFinishAction = 'cl=order&fnc=execute';
	protected $_sDemoFinishAction = 'cl=order&fnc=showSccpFinished';

	/**
	 * Wenn Bezahlung per sccp_financing kommt, Post Daten prüfen.
	 * @return String Template Filename
	 * @throws ESCore\Exception\SystemComponentException
	 */
	public function render() {
		$oPayment = $this->getPayment();
		if ( $oPayment && ($oPayment->oxpayments__oxid->value == 'sccp_financing') ) {
			$oRequest = ESCore\Registry::getRequest();
			$bGotoNewAction = false;
			$aParams = array();
			if ( $oRequest->getRequestParameter('data') && $oRequest->getRequestParameter('signature') ) {
				/** @see \Sinkacom\CreditPlusModule\Model\Paymentgateway::getTargetURL for reverse order of functions applied to $_GET['data'] */
				$_POST['params'] = unserialize(gzinflate(base64_decode($oRequest->getRequestParameter('data',true))));
				$aParams = $_POST['params'];

			}
			// Wenn aParams nicht leer ist, durchgehen und neue Action aufrufen
			if ( $aParams ) {
				foreach ( $aParams as $sKey => $sValue ) {
					$_POST[$sKey] = $sValue;
				}
				$bGotoNewAction = true;
			}
			if ( $bGotoNewAction ) {
				$sNewAction = $this->execute();
				if ( $sNewAction ) {
					$this->_executeNewAction( $sNewAction );
				}
			}
		}
		return parent::render();
	}


	public function restartSccpOrder() {
		$oRequest = ESCore\Registry::getRequest();
		$sTransID = $oRequest->getRequestParameter('don');
		$sOxid = $oRequest->getRequestParameter('oxid');
		if ( $sOxid && $sTransID ) {
			/** @var ESModel\Order $oOrder */
			try{
				$oOrder = oxNew(ESModel\Order::class);
				if ( $oOrder->load($sOxid) ) {
					if ( $oOrder->oxorder__oxtransid->value == $sTransID ) {
						/** @var ESModel\Basket $oBasketNew */
						$oBasketNew = oxNew(ESModel\Basket::class);
						/** @var ESModel\OrderArticle[] $oOrderArticles */
						$oOrderArticles = $oOrder->getOrderArticles();
						foreach ( $oOrderArticles as $oOrderArticle ) {
							$sArtOxid = $oOrderArticle->oxorderarticle__oxartid->value;
							$dAmount = $oOrderArticle->oxorderarticle__oxamount->value;
							$aSels = $oOrderArticle->getOrderArticleSelectList();
							$aPersParams = $oOrderArticle->getPersParams();
							$oBasketNew->addToBasket($sArtOxid,$dAmount,$aSels,$aPersParams);
						}
						$oBasketNew->calculateBasket(true);
						$this->getSession()->setBasket($oBasketNew);
						$oOrder->cancelOrder();
					}
				}
			} catch( ESCore\Exception\OutOfStockException $oEx ) {
				// Article out of stock, shouldn't happen
			} catch( ESCore\Exception\NoArticleException $oEx ) {
				// No Article provided, must be a weird construction
			} catch( ESCore\Exception\ArticleInputException $oEx ) {
				// Article input malformed, must be a weird construction
			}
		}
	}

	/**
	 * Wenn der Weg über iFrame gewählt wird, dann einfach nur die URL mit htmlentities encoden und das iframe Tempalte ausgeben.
	 */
	public function showSccpIframe () {
		$oSession = $this->getSession();
		$this->_aViewData['sTargetURL'] = htmlentities($oSession->getVariable('sTargetURL'));
		$this->_sThisTemplate = 'sccp_checkout_iframed.tpl';
	}

	/**
	 * Wenn der Weg über Popup gewählt wird, dann einfach nur die URL mit htmlentities encoden und das popup Tempalte ausgeben.
	 */
	public function showSccpPopup () {
		$oSession = $this->getSession();
		$this->_aViewData['sTargetURL'] = htmlentities($oSession->getVariable('sTargetURL'));
		$this->_sThisTemplate = 'sccp_checkout_popup.tpl';
	}

	/**
	 * Wenn alles abgelaufen ist, Weiterleitungsseite zum internen Ziel anzeigen
	 */
	public function showSccpFinished() {
		$oConfig = $this->getConfig();
		$this->_aViewData['sTargetURL'] = $oConfig->getShopSecureHomeUrl().$this->_sFinishAction;
		$this->_aViewData['sHiddenFields'] = $this->getviewConfig()->getNavFormParams();
		$this->_aViewData['sParams'] = htmlentities(base64_decode($_POST['params']));
		$this->_aViewData['sSignature'] = htmlentities($_POST['signature']);
		$this->_sThisTemplate = 'sccp_checkout_finished.tpl';
	}
}

class_alias(Order::class,'sccp_order');

