<?php
/**
 * This file is part of the SinkaCom CreditPlus Module Package.
 *
 * @link      http://www.sinkacom.de/
 * @copyright (C) SinkaCom AG 2015-2019
 * @version   OXID eShop CE
 */
/**
 * Created by PhpStorm.
 * User: sinkacom
 * Date: 15.02.16
 * Time: 15:42
 */

namespace Sinkacom\CreditPlusModule\Controller;

use Sinkacom\CreditPlusModule\Component\CommonsComponent;

class Thankyou extends Thankyou_parent {
	public function render() {
		$sReturn = parent::render();
		$oConfig = $this->getConfig();
		$oShop = $oConfig->getActiveShop();
		/** @var CommonsComponent $oCommons */
		$oCommons = oxNew('Sinkacom\CreditPlusModule\Component\CommonsComponent');
		$oCommons->addFinancingStyles();
		$oOrder = $this->getOrder();
		if ( $oOrder->oxorder__oxpaymenttype->value == 'sccp_financing' ) {
			$sShownAs = $oConfig->getShopConfVar('sCPShownAs',$oShop->oxshops__oxid->value,'module:sccp');
			if ( $sShownAs == 'popup' ) {
				$this->_aViewData['sContinueToPaymentURL'] = $this->getViewConfig()->getSelfActionLink().'cl=sinkacom_creditplusmodule_trigger&fnc=showSccpPopup&don='.$oOrder->oxorder__oxtransid->value.'&oxid='.$oOrder->oxorder__oxid->value;
			} elseif ($sShownAs == 'iframe') {
				$this->_aViewData['sContinueToPaymentURL'] = $this->getViewConfig()->getSelfActionLink().'cl=sinkacom_creditplusmodule_trigger&fnc=showSccpIframe&don='.$oOrder->oxorder__oxtransid->value.'&oxid='.$oOrder->oxorder__oxid->value;
			}

			$this->_aViewData['sCancelAndSwapPaymentURL'] = $this->getViewConfig()->getSelfActionLink().'cl=sinkacom_creditplusmodule_restartorder&don='.$oOrder->oxorder__oxtransid->value.'&oxid='.$oOrder->oxorder__oxid->value;
		}
		$oSession = $this->getSession();
		/** @var \Sinkacom\CreditPlusModule\Model\Order $oSavedOrder */
		if ( $oSession->hasVariable('oCreatedOrder') ) {
			$oSession->deleteVariable('oCreatedOrder');
		}
		return $sReturn;
	}
}

class_alias(Thankyou::class,'sccp_thankyou');

