<?php
/**
 * This file is part of the SinkaCom CreditPlus Module Package.
 *
 * @link      http://www.sinkacom.de/
 * @copyright (C) SinkaCom AG 2015-2019
 * @version   OXID eShop CE
 */

namespace Sinkacom\CreditPlusModule\Controller;
use DateTime;
use Exception;
use OxidEsales\Eshop\Application\Controller\FrontendController;
use Sinkacom\CreditPlusModule\Component\CommonsComponent;
use Sinkacom\CreditPlusModule\Model\RequestQueue;
use Sinkacom\CreditPlusModule\Model as SCModel;
use \OxidEsales\Eshop\Core as ESCore;
use \OxidEsales\Eshop\Application\Model as ESModel;

/**
 * Created by PhpStorm.
 * User: sinkacom
 * Date: 10.02.16
 * Time: 13:53
 */
//class sccp_trigger extends oxUBase {
class Trigger extends FrontendController {

	protected $_sThisTemplate = 'sccp_trigger.tpl';

	protected $_sFinishedURL = 'cl=sinkacom_creditplusmodule_trigger&fnc=showSccpFinished&don=###DON###&oxid=###OXID###';
	protected $_sRestartURL = 'cl=sinkacom_creditplusmodule_restartorder&don=###DON###&oxid=###OXID###';
	protected $_sRestartDirectURL = 'cl=sinkacom_creditplusmodule_restartorder&fnc=cancelAndReorder&payerror=13021&don=###DON###&oxid=###OXID###';
	protected $_sRestartInfoURL = 'cl=sinkacom_creditplusmodule_restartorder&fnc=showInfo&don=###DON###&oxid=###OXID###';

	public function keepSession() {
		$this->_aViewData['iStatusCode'] = 200;
		$this->_aViewData['sStatusText'] = 'The session has been updated.';
	}

	public function finishContract() {
		$oRequest = ESCore\Registry::getRequest();
		$sDealerOrderNumber = $oRequest->getRequestParameter('don');
		$iStatusCode = intval($oRequest->getRequestParameter('statusCode'));
		$this->updateContractWorker($sDealerOrderNumber, $iStatusCode);
	}

	/**
	 * @param string $sURL
	 * @param string $sDON
	 * @param string $sOXID
	 * @return string
	 */
	protected function getReplacedURL( $sURL, $sDON = '', $sOXID = '' ) {
		return str_replace(array(
			'###DON###',
			'###OXID###'
		), array(
			$sDON,
			$sOXID
		), $sURL);
	}

	/**
	 * @param SCModel\Order|ESModel\Order $oOrder
	 * @param int $iStatusCode
	 */
	protected function finishContractWorker( &$oOrder, $iStatusCode ) {
		$aGoodStates = array(
			// Tentative OK or Hard OK, customer needs to sign or has signed contract accepted by the bank
			24,
			// Payment in progress (Bank to Shop)
			32,
			// Contract is already paid (Bank to Shop)
			99
		);
		$aGreyStates = array(
			// Open - Manual decision
			20,
			// Open - Additional info required from customer
			25,
		);
		$aBadStates = array(
			// Unknown Error
			2,
			// Declined - soft
			92,
			// Declined - hard
			93
		);
		$aChangeStates = array(
			// Change trigger, request current state from other side
			3,
		);
		/** @var ESCore\Utils $oUtils */
		$oUtils = ESCore\Registry::getUtils();
		/** @var ESCore\UtilsUrl $oUtilsUrl */
		$oUtilsUrl = ESCore\Registry::get(ESCore\UtilsUrl::class);

		if ( in_array($iStatusCode, $aGoodStates) ) {
			$oOrder->oxorder__oxtransstatus = new ESCore\Field('OK');
			$oOrder->oxorder__oxfolder = new ESCore\Field('ORDERFOLDER_NEW');
			$oOrder->save();
			$sRedirectURL = $oUtilsUrl->processUrl('index.php?'.
				$this->getReplacedURL(
					$this->_sFinishedURL,
					$oOrder->oxorder__oxtransid->value,
					$oOrder->oxorder__oxid->value
				)
			);
			$oUtils->redirect($sRedirectURL, false, 301);
			$oUtils->showMessageAndExit('');
		} elseif ( in_array($iStatusCode, $aBadStates) ) {
			$oOrder->oxorder__oxtransstatus = new ESCore\Field('PAYMENT_DECLINED');
			$oOrder->oxorder__oxfolder = new ESCore\Field('ORDERFOLDER_PROBLEMS');
			$oOrder->save();
			$sRedirectURL = $oUtilsUrl->processUrl('index.php?'.
				$this->getReplacedURL(
					$this->_sRestartDirectURL,
					$oOrder->oxorder__oxtransid->value,
					$oOrder->oxorder__oxid->value
				)
			);
			$oUtils->redirect($sRedirectURL, false, 301);
			$oUtils->showMessageAndExit('');
		} elseif ( in_array($iStatusCode, $aGreyStates) ) {
			$oOrder->oxorder__oxtransstatus = new ESCore\Field('OK');
			$oOrder->oxorder__oxfolder = new ESCore\Field('ORDERFOLDER_NEW');
			$oOrder->save();
			$sRedirectURL = $oUtilsUrl->processUrl('index.php?'.
				$this->getReplacedURL(
					$this->_sFinishedURL,
					$oOrder->oxorder__oxtransid->value,
					$oOrder->oxorder__oxid->value
				)
			);
			$oUtils->redirect($sRedirectURL, false, 301);
			$oUtils->showMessageAndExit('');
		} else if( in_array($iStatusCode, $aChangeStates) ){
			try {
				/** @var CommonsComponent $oCmpCommons */
				$oCmpCommons = oxNew(CommonsComponent::class);
				$oCmpCommons->getContractDataMultiple(array(
					$oOrder->oxorder__oxtransid->value,
					$oOrder->oxorder__oxordernr->value,
				));
				$oCmpCommons->checkForUpdateMail($oOrder);
				$this->_aViewData['iStatusCode'] = 200;
				$this->_aViewData['sStatusText'] = 'Update has been triggered.';
			} catch ( Exception $oEx ) {
				// Order is already queued for update
				$this->_aViewData['iStatusCode'] = 500;
				$this->_aViewData['sStatusText'] = 'Update not triggered directly. Another update for this order is already queued.".';
			}
		}

		if ( !isset($this->_aViewData['iStatusCode']) ) {
			$this->_aViewData['iStatusCode'] = 500;
			$this->_aViewData['sStatusText'] = 'Unknown Status code ('.$iStatusCode.').';
		}
	}

	public function updateContract() {
		$oRequest = ESCore\Registry::getRequest();
		$sDealerOrderNumber = $oRequest->getRequestParameter('don');
		$iStatus = intval($oRequest->getRequestParameter('callback'));
		$this->updateContractWorker($sDealerOrderNumber, $iStatus);
	}

	/**
	 * @param string $sDealerOrderNumber
	 * @param int $iStatus
	 */
	protected function updateContractWorker( $sDealerOrderNumber, $iStatus ) {
		if ( $sDealerOrderNumber ) {
			try {
				// Select Order from Database and update fields
				$oDB = ESCore\DatabaseProvider::getDb(ESCore\DatabaseProvider::FETCH_MODE_NUM);
				/** @var ESCore\Database\Adapter\Doctrine\ResultSet $oRes */
				$oRes = $oDB->select("SELECT OXID FROM oxorder WHERE OXTRANSID = '$sDealerOrderNumber'");
			} catch ( ESCore\Exception\DatabaseConnectionException $e ) {
				$oRes = null;
			} catch ( ESCore\Exception\DatabaseErrorException $e ) {
				$oRes = null;
			}
			if ( $oRes && $oRes->count() ) {
				$sOrderID = $oRes->fields[0];
				/** @var SCModel\Order|ESModel\Order $oOrder */
				$oOrder = oxNew(ESModel\Order::class);
				if ( $oOrder->load($sOrderID) ) {
					// This should update the fields respectively
					$oOrder->getContractData();
					if ( $oOrder->oxorder__oxtransstatus->value == 'PAYMENT_PENDING' ) {
						$this->finishContractWorker($oOrder, $iStatus);
					}
					try{
						/** @var CommonsComponent $oCmpCommons */
						$oCmpCommons = oxNew(CommonsComponent::class);
						$oCmpCommons->checkForUpdateMail($oOrder);
					} catch( Exception $oEx){
						// Order is already queued for update
						$this->_aViewData['iStatusCode'] = 500;
						$this->_aViewData['sStatusText'] = 'Update not triggered directly. Another update for this order is already queued.';
					}
					if ( !isset($this->_aViewData['iStatusCode']) ) {
						$this->_aViewData['iStatusCode'] = 200;
						$this->_aViewData['sStatusText'] = 'Order was updated.';
					}
				} else {
					$this->_aViewData['iStatusCode'] = 500;
					$this->_aViewData['sStatusText'] = 'Order could not be loaded';
				}
			} else {
				$this->_aViewData['iStatusCode'] = 404;
				$this->_aViewData['sStatusText'] = 'Dealer Order Number (don) was not found on this system';
			}
		} else {
			$this->_aViewData['iStatusCode'] = 400;
			$this->_aViewData['sStatusText'] = 'Dealer Order Number (don) is missing';
		}

	}

	/**
	 * Wenn alles abgelaufen ist, Weiterleitungsseite zum internen Ziel anzeigen
	 */
	public function showSccpFinished() {
		$oConfig = $this->getConfig();
		$oRequest = ESCore\Registry::getRequest();
		if ( $oRequest->getRequestParameter('error') ) {

			if ( $oConfig->getShopConfVar('sTransactionMode',null,'module:sccp') == 'inorder' ) {
				$this->_sFinishedURL = 'cl=payment';
			}

			$this->_aViewData['sTargetURL'] = $oConfig->getShopSecureHomeUrl().
				$this->getReplacedURL(
					$this->_sFinishedURL,
					$oRequest->getRequestParameter('don'),
					$oRequest->getRequestParameter('oxid')
				);
			$this->_aViewData['sClass'] = 'sinkacom_creditplusmodule_trigger';
			$this->_aViewData['sFunction'] = 'showSccpFinished';

			if ( $oConfig->getShopConfVar('sTransactionMode',null,'module:sccp') == 'inorder' ) {
				$this->_aViewData['sClass'] = 'payment';
				$this->_aViewData['sFunction'] = '';
			}

			/** @var ESCore\Language $oLang */
			$oLang = ESCore\Registry::getLang();

			$sRestartURL = $oConfig->getShopSecureHomeUrl().
				$this->getReplacedURL(
					$this->_sRestartURL,
					$oRequest->getRequestParameter('don'),
					$oRequest->getRequestParameter('oxid')
				);
			$this->_aViewData['sFinanceError'] = str_replace('###URL###', $sRestartURL, $oLang->translateString('SCCP_FINANCING_FINISHED_ERRORS'));
		} else {
			/** @var ESModel\Content $oContent */
			$oContent = oxNew(ESModel\Content::class);

			// Thank You Page with custom text
			if ( $oContent->loadByIdent('sccpeverythingfinished') ) {
				$this->_aViewData['sTargetURL'] = $oContent->getLink();
				$this->_aViewData['sContentOxid'] = $oContent->getId();
				$this->_aViewData['sClass'] = 'content';
				$this->_aViewData['sFunction'] = '';

				if ( $oConfig->getShopConfVar('sTransactionMode',null,'module:sccp') == 'inorder' ) {
					$this->_aViewData['sTargetURL'] = $oConfig->getShopSecureHomeUrl().'cl=order&fnc=execute';
					$this->_aViewData['sClass'] = 'order';
					$this->_aViewData['sFunction'] = 'execute';
				}
			} else {
				$this->_aViewData['sTargetURL'] = $oConfig->getShopSecureHomeUrl();
				$this->_aViewData['sClass'] = 'start';
				$this->_aViewData['sFunction'] = '';

				if ( $oConfig->getShopConfVar('sTransactionMode',null,'module:sccp') == 'inorder' ) {
					$this->_aViewData['sTargetURL'] = $oConfig->getShopSecureHomeUrl().'cl=payment';
					$this->_aViewData['sClass'] = 'payment';
					$this->_aViewData['sFunction'] = '';
				}
			}
		}
		$this->_aViewData['sHiddenFields'] = $this->getViewConfig()->getNavFormParams();
		$this->_aViewData['sParams'] = '';
		$this->_aViewData['sSignature'] = '';
		if ( ($this->_aViewData['sClass'] == 'order') && ($this->_aViewData['sFunction'] == 'execute') ) {
			$this->_aViewData['sHiddenFields'] .= '<input type="hidden" name="stoken" value="'.$this->getSession()->getSessionChallengeToken().'" />';
			$this->_aViewData['sHiddenFields'] .= '<input type="hidden" name="ord_agb" value="1" />';
		}
		if ( ($oConfig->getShopConfVar('sTransactionMode',null,'module:sccp') == 'inorder') ) {
			/** @var SCModel\Order|ESModel\Order $oSavedOrder */
			$oSavedOrder = $this->getSession()->getVariable('oCreatedOrder');
			/** @var SCModel\Order|ESModel\Order $oOrder */
			$oOrder = oxNew(ESModel\Order::class);

			$oOrder->load($oSavedOrder->getId());
			$this->_aViewData['sHiddenFields'] .= '<input type="hidden" name="sDeliveryAddressMD5" value="'.$oSavedOrder->sDeliveryAddressHash.'" />';
			$this->getSession()->setVariable('oCreatedOrder', $oOrder);
			$oOrder->delete();
		}
		$this->_sThisTemplate = 'sccp_checkout_finished.tpl';
	}


	/**
	 * Wenn der Weg über iFrame gewählt wird, dann einfach nur die URL mit htmlentities encoden und das iframe Tempalte ausgeben.
	 */
	public function showSccpIframe() {
		$this->showCommon();
		$this->_aViewData['sTargetURL'] = htmlentities($this->_aViewData['sTargetURL']);
		$this->_sThisTemplate = 'sccp_checkout_iframed.tpl';
	}

	/**
	 * Wenn der Weg über Popup gewählt wird, dann einfach nur die URL mit htmlentities encoden und das popup Tempalte ausgeben.
	 */
	public function showSccpPopup() {
		$this->showCommon();
		$aNewParams = [];
		foreach ( $this->_aViewData['aGetParams'] as $sKey => $sValue ) {
			$aNewParams[urldecode($sKey)] = urldecode($sValue);
		}
		$this->_aViewData['aGetParams'] = $aNewParams;
		$this->_sThisTemplate = 'sccp_checkout_popup.tpl';
	}

	protected function showCommon() {
		$oSession = $this->getSession();
		$oRequest = ESCore\Registry::getRequest();
		if ( !$oSession->hasVariable('sTargetURL') || ($oRequest->getRequestParameter('don') && $oRequest->getRequestParameter('oxid')) ) {
			$sTargetURL = $this->makePaymentFromGetParams();
		} else {
			$sTargetURL = $oSession->getVariable('sTargetURL');
		}
		$this->_aViewData['sBackURL'] = $this->getBackURL();
		$this->_aViewData['sTargetURL'] = $sTargetURL;
		$aGetParams = array();
		if ( strpos($sTargetURL,'?') !== false ) {
			$aURL = explode('?', $sTargetURL, 2);
			$sParams = $aURL[1];
			if ( $sParams ) {
				$aParams = explode('&', $sParams);
				foreach ( $aParams as $sParam ) {
					$aParam = explode('=', $sParam, 2);
					$aGetParams[$aParam[0]] = $aParam[1];
				}
			}
		}
		$this->_aViewData['aGetParams'] = $aGetParams;
	}

	/**
	 * @return string Target URL (Payment page on CreditPlus)
	 */
	protected function makePaymentFromGetParams() {
		$oRequest = ESCore\Registry::getRequest();
		$sDON = $oRequest->getRequestParameter('don');
		$sOXID = $oRequest->getRequestParameter('oxid');
		if ( $sDON && $sOXID ) {
			try{
				/** @var SCModel\Order|ESModel\Order $oOrder */
				$oOrder = oxNew(ESModel\Order::class);
				if ( $oOrder->load($sOXID) ) {
					if ( $oOrder->oxorder__oxtransid->value == $sDON ) {
						$oOrderData = $oOrder->getContractData();
						if ( !$oOrderData || $oOrderData->state == '' ) {
							/** @var SCModel\Paymentgateway $oPaymentGateway */
							$oPaymentGateway = oxNew(ESModel\PaymentGateway::class);
							$sTargetURL = $oPaymentGateway->getTargetURL($oOrder,$oOrder->oxorder__oxtotalordersum->value);
							$oOrder->setSccpOxorderFinance($sTargetURL,time());
							$oOrder->save();
							$oSession = $this->getSession();
							$oSession->setVariable('sTargetURL',$sTargetURL);
							$oSession->setVariable('oCreatedOrder',$oOrder);
						} else {
							/** @var ESModel\Content $oContentFinished */
							$oContentFinished = oxNew(ESModel\Content::class);
							$oContentFinished->loadByIdent('sccpalreadyfinished');
							$sTargetURL = $oContentFinished->getLink();
							/** @var ESCore\Utils $oUtils */
							$oUtils = ESCore\Registry::getUtils();
							$oUtils->redirect($sTargetURL,false,301);
							$oUtils->showMessageAndExit('');
						}
						return $sTargetURL;
					}
				}
			} catch ( Exception $oEx ) {
				// Object type not found, doesn't happen
				return '';
			}
		}
		/** @var ESModel\Content $oContent */
		$oContent = oxNew(ESModel\Content::class);
		$oContent->loadByIdent('sccptechnicalerror');
		return $oContent->getLink();
	}

	/**
	 * @return string URL to use instead of history.back();
	 */
	protected function getBackURL() {
		$oConfig = $this->getConfig();
		$oRequest = ESCore\Registry::getRequest();
		/** @var ESCore\UtilsUrl $oUtilsURL */
		$oUtilsURL = ESCore\Registry::get(ESCore\UtilsUrl::class);
		if ( $oConfig->getShopConfVar('sTransactionMode',null,'module:sccp') == 'inorder' ) {
			$sBackURL = $oUtilsURL->processUrl('index.php?cl=payment');
		} else {
			$sDON = $oRequest->getRequestParameter('don');
			$sOrderOXID = $oRequest->getRequestParameter('oxid');
			/** @var SCModel\Order|ESModel\Order $oOrder */
			$oOrder = oxNew(ESModel\Order::class);

			if ( $sDON && $sOrderOXID && ($oOrder->load($sOrderOXID) && ($oOrder->oxorder__oxtransid->value == $sDON) ) ) {
				$sBackURL = $oUtilsURL->processUrl('index.php?'.
					$this->getReplacedURL(
						$this->_sRestartInfoURL,
						$sDON,
						$sOrderOXID
					)
				);
			} else {
				$sBackURL = $oUtilsURL->processUrl('index.php?');
			}
		}
		return $sBackURL;
	}

	public function testRate() {
		$oRequest = ESCore\Registry::getRequest();
		$dPrice = floatval($oRequest->getRequestParameter('dPrice'));
		$iMonths = intval($oRequest->getRequestParameter('iMonths'));
		$dInterest = floatval($oRequest->getRequestParameter('dInterest'));

		header('Content-type: text/plain; charset=utf-8');
		/** @var CommonsComponent $oCmpCommons */
		$oCmpCommons = oxNew(CommonsComponent::class);
		$oWSApi = $oCmpCommons->getWebshopAPI();
		$dEffective = $oWSApi->getEffectiveInterestFromNominalInterest($dInterest);
		$dNominal = $oWSApi->getNominalInterestFromEffectiveInterest($dInterest);
		var_dump(array(
			'dPrice' => $dPrice,
			'iMonths' => $iMonths,
			'dInterest' => $dInterest,
			'dEffectiveInterest' => $dEffective,
			'dNominal' => $dNominal
		));

		$dReturn = $oWSApi->getMonthRateByPriceMonthsAndInterest($dPrice, $iMonths, $dNominal);
		$oUtils = ESCore\Registry::getUtils();
		$oUtils->showMessageAndExit($dReturn.'');
	}

	public function testProductRate() {
		header('Content-type: text/plain; charset=utf-8');
		/** @var SCModel\Article|ESModel\Article $oArticle */
		$oArticle = oxNew(ESModel\Article::class);
		$oArticle->load('b56597806428de2f58b1c6c7d3e0e093');
		$aFinancingMonths1 = $oArticle->getSccpFinancingMonths(0.01);
		$oArticle = oxNew(ESModel\Article::class);
		$oArticle->load('058e613db53d782adfc9f2ccb43c45fe');
		$aFinancingMonths2 = $oArticle->getSccpFinancingMonths(0.01);

		$oUtils = ESCore\Registry::getUtils();
		$oUtils->showMessageAndExit(var_export($aFinancingMonths1, true)."\r\n".var_export($aFinancingMonths2, true));
	}

	public function testSignature() {
		$_SERVER['REQUEST_URI'] = str_replace('&fnc=testSignature','&fnc=dispatch',$_SERVER['REQUEST_URI']);
		$oRequest = ESCore\Registry::getRequest();
		$sDON = $oRequest->getRequestParameter('don');
		$oOrder = null;
		if ( isset($sDON) && $sDON ) {
			try {
				$oDB = ESCore\DatabaseProvider::getDb( ESCore\DatabaseProvider::FETCH_MODE_ASSOC );
				/** @var ESCore\Database\Adapter\Doctrine\ResultSet $oRes */
				$oRes = $oDB->select('SELECT oxid FROM oxorder WHERE oxtransid = ?', array($sDON));
				if ($oRes && ($oRes->count() > 0) ) {
					$sOXID = $oRes->fields['oxid'];
					/** @var SCModel\Order|ESModel\Order $oOrder */
					$oOrder = oxNew(ESModel\Order::class);
					$oOrder->load($sOXID);
				}
			} catch ( ESCore\Exception\DatabaseConnectionException $oEx ) {
				// No DB, no problem
			} catch ( ESCore\Exception\DatabaseErrorException $oEx ) {
				// No DB, no problem
			}
		}
		$bSignOK = $this->checkSignature('', $oOrder);
		$oUtils = ESCore\Registry::getUtils();
		$oUtils->showMessageAndExit(var_export($bSignOK, true).'');
	}

	/**
	 * Checks if the signature is correct. If bTestMode is active, any signature is accepted.
	 * If bTestMode is not set, only the two possible calculations are accepted.
	 * @param string $sSignature Signature given by request - Signing Parameter callback and the Base URL before that
	 * @param SCModel\Order $oOrder Order object or null
	 * @return bool True if $sSignature is OK, false if not
	 */
	protected function checkSignature( $sSignature = '', $oOrder = null ) {
		$oConfig = $this->getConfig();
		$oRequest = ESCore\Registry::getRequest();
		$bTestMode = $oConfig->getShopConfVar('bTestMode', null, 'module:sccp');
		if ( $bTestMode && ($oRequest->getRequestParameter('fnc') !== 'testSignature') ) {
			return true;
		} else {

			// Do a real check in Live Mode and even Test Mode (if not 'bogus')
			$sSaltValue = $oConfig->getShopConfVar('sSignatureSalt', null, 'module:sccp');
			$sSignature = $sSignature?$sSignature:$oRequest->getRequestParameter('signature');
			$sDON = $oRequest->getRequestParameter('don');
			$sCallback = $oRequest->getRequestParameter('callback');
			$sData = $oRequest->getRequestParameter('data');
			$sSignedURL = $oConfig->getCurrentShopUrl().'?cl=sinkacom_creditplusmodule_trigger&data='.urlencode($sData).'&fnc=dispatch&don='.$sDON.'&';
			// URL+Salt+Callback
			$bValid = ($sSignature == md5($sSignedURL.$sSaltValue.$sCallback));
			// or DON+Salt+Callback
			$bValid = $bValid || ($sSignature == md5($sDON.$sSaltValue.$sCallback));
			// or Order Number+Salt+Callback
			if ( isset($oOrder) && $oOrder && ($sOrderNumber = $oOrder->oxorder__oxordernr->value) ) {
				$bValid = $bValid || ($sSignature == md5($sOrderNumber.$sSaltValue.$sCallback));
			}
			if ( $oRequest->getRequestParameter('fnc') == 'testSignature' ) {
				var_dump(md5($sSignedURL.$sSaltValue.$sCallback));
				var_dump(md5($sDON.$sSaltValue.$sCallback));
				if ( isset($sOrderNumber) && $sOrderNumber ) {
					var_dump(md5($sOrderNumber.$sSaltValue.$sCallback));
				}
			}
			return $bValid;
		}
	}

	/**
	 * This function sends the request for updates, Keep-Alive and finish into the correct worker functions.
	 */
	public function dispatch() {
		$oConfig = $this->getConfig();
		$oRequest = ESCore\Registry::getRequest();
		$iStatus = intval($oRequest->getRequestParameter('callback'));
		$sSignature = $oRequest->getRequestParameter('signature');
		if ( $this->checkSignature($sSignature) === false ) {
			$this->_aViewData['iStatusCode'] = 400;
			$this->_aViewData['sStatusText'] = 'Signature and Data have a mismatch';
			return;
		}

		if ( $iStatus === 1 ) {
			$this->keepSession();
			return;
		}
		$sData = $oRequest->getRequestParameter('data');
		$sDON = $oRequest->getRequestParameter('don');
		if ( $sData ) {
			try {
				$aData = unserialize(gzinflate(base64_decode($sData)));
				if ( ($oConfig->getShopConfVar('sTransactionMode',null,'module:sccp') == 'inorder') && (!$this->getOrder($sDON)) ) {
					$this->createOrderFromSession();
				}
				$this->updateContractWorker($sDON, $iStatus);
			} catch ( Exception $e ) {
				$this->_aViewData['iStatusCode'] = 400;
				if ( !isset($aData) ) {
					$aData = false;
				}
				$this->writeRequestQueue($sDON);
				$this->_aViewData['sStatusText'] = "Data (data) is not formatted correctly. Given: $sData Parsed: ".var_export($aData, true);
			}
		} else {
			$this->_aViewData['iStatusCode'] = 400;
			$this->_aViewData['sStatusText'] = 'Data (data) is missing';
		}
	}

	/**
	 * @param string $sDealerOrderNumber
	 *
	 * @return null|SCModel\Order
	 */
	protected function getOrder($sDealerOrderNumber) {
		if ( $sDealerOrderNumber ) {
			// Select Order from Database and update fields
			try{
				$oDB = ESCore\DatabaseProvider::getDb(ESCore\DatabaseProvider::FETCH_MODE_NUM);
				/** @var ESCore\Database\Adapter\Doctrine\ResultSet $oRes */
				$oRes = $oDB->select("SELECT OXID FROM oxorder WHERE OXTRANSID = '$sDealerOrderNumber'");
				if ( $oRes && $oRes->count() ) {
					$sOrderID = $oRes->fields[0];
					/** @var SCModel\Order|ESModel\Order $oOrder */
					$oOrder = oxNew(ESModel\Order::class);
					if ( $oOrder->load($sOrderID) ) {
						return $oOrder;
					}
				}
			} catch ( ESCore\Exception\DatabaseConnectionException $oEx ) {
				// No DB = no Order
				return null;
			} catch ( ESCore\Exception\DatabaseErrorException $oEx ) {
				// No valid Select = no Order
				return null;
			}
		}
		return null;
	}

	/**
	 * Takes the session variable created on redirect from payment and puts it back into the database
	 */
	protected function createOrderFromSession() {
		$oSession = $this->getSession();
		$oOrder = $oSession->getVariable('oCreatedOrder');
		if ( $oOrder ) {
			$oOrder->save();
		}
	}

	/**
	 * @param string $sDON
	 *
	 */
	protected function writeRequestQueue( $sDON ) {
		try {
			/** @var CommonsComponent $oCmpCommons */
			$oCmpCommons = oxNew(CommonsComponent::class);
			$oWSApi = $oCmpCommons->getWebshopAPI();
			$oDB = ESCore\DatabaseProvider::getDb(ESCore\DatabaseProvider::FETCH_MODE_ASSOC);
			/** @var ESCore\Database\Adapter\Doctrine\ResultSet $oRes */
			$oRes = $oDB->select("SELECT oxid FROM oxorder WHERE oxtransid = '$sDON'");
			$sOrderOXID = null;
			if ( $oRes && $oRes->count() ) {
				$sOrderOXID = $oRes->fields['oxid'];
			}
			if ( $sOrderOXID === null ) {
				// No order, no retry
				return;
			}
			/** @var ESModel\Order $oOrder */
			$oOrder = oxNew(ESModel\Order::class);
			$oOrder->load($sOrderOXID);
			if ( $oOrder->isLoaded() && !$oWSApi->isApiCallable() ) {
				$oRes = $oDB->select("SELECT oxid FROM sccp_requestqueue WHERE ((scorderid = '$sOrderOXID') AND (scalreadyexecuted = 0))");
				// Only if no unexecuted exist
				if ( !$oRes || $oRes->count() === 0 ) {
					/** @var RequestQueue $oRQ */
					$oRQ = oxNew(RequestQueue::class);
					$oRQ->setId();
					try {
						$oDate = new DateTime();
					} catch ( Exception $oEx ) {
						$oDate = date_create();
					}
					$oRQ->assign( array(
						'sccp_requestqueue__scorderid'       => $sOrderOXID,
						'sccp_requestqueue__scalreadyexecuted' => 0,
						'sccp_requestqueue__scexecutiondate'   => $oDate,
						'sccp_requestqueue__scretryround'      => 1,
					) );
					$oRQ->save();
				}
			}
		} catch ( ESCore\Exception\DatabaseConnectionException $oEx ) {
			// No connection to database
			return;
		} catch ( ESCore\Exception\DatabaseErrorException $oEx ) {
			//Query has a bug
			return;
		} catch ( Exception $oEx ) {
			// Object types not found
			return;
		}
	}

	public function render() {
		$sReturn = parent::render();

		// Only if no function has changed the template
		if ( $sReturn == 'sccp_trigger.tpl' ) {
			if ( !isset($this->_aViewData['iStatusCode']) ) {
				$this->_aViewData['iStatusCode'] = 200;
				$this->_aViewData['sStatusText'] = 'No errors detected.';
			}
			/** @var ESCore\Utils $oUtils */
			$oUtils = ESCore\Registry::get(ESCore\Utils::class);
			/** @var ESCore\UtilsView $oUtilsView */
			$oUtilsView = ESCore\Registry::get(ESCore\UtilsView::class);
			$oSmarty = $oUtilsView->getSmarty();
			$oSmarty->assign($this->_aViewData);
			$sText = $oSmarty->fetch($sReturn);

			header('Content-type: text/xml; charset=utf-8');
			$oUtils->showMessageAndExit($sText);
		} else {
			/** @var CommonsComponent $oCommons */
			$oCommons = oxNew('Sinkacom\CreditPlusModule\Component\CommonsComponent');
			$oCommons->addFinancingStyles();
		}

		return $sReturn;
	}

	/**
	 * @inheritdoc
	 */
	public function getBreadCrumb() {
		$aPaths = parent::getBreadCrumb();
		if ( !$aPaths ) {
			$aPaths = array();
		}

		$oConfig = $this->getConfig();
		$oRequest = ESCore\Registry::getRequest();


		/** @var ESCore\Language $oLang */
		$oLang = ESCore\Registry::getLang();
		/** @var ESCore\SeoEncoder $oSeoEncoder */
		$oSeoEncoder = ESCore\Registry::get(ESCore\SeoEncoder::class);


		$iBaseLanguage = $oLang->getBaseLanguage();
		$sSelfLink = $this->getViewConfig()->getSelfLink();

		$aPath = array();
		$aPath['title'] = $oLang->translateString('PAY', $iBaseLanguage, false);
		$aPath['link'] = $oSeoEncoder->getStaticUrl($sSelfLink.'cl=payment');
		$aPaths[] = $aPath;

		$sFunction = $oRequest->getRequestParameter('fnc');
		$sTransactionMode = $oConfig->getShopConfVar('sTransactionMode', null, 'module:sccp');
		if ( ($sFunction == 'showSccpPopup') || ($sFunction == 'showSccpIframe') ) {
			if ( $sTransactionMode == 'postorder' ) {
				$aPath = array();
				$aPath['title'] = $oLang->translateString('SCCP_FINANCING_BREADCRUMB_PAYPOSTORDER', $iBaseLanguage, false);
				$aPath['link'] = $this->getLink();
				$aPaths[] = $aPath;
			} elseif ( $sTransactionMode == 'inorder' ) {
				$aPath = array();
				$aPath['title'] = $oLang->translateString('SCCP_FINANCING_BREADCRUMB_PAYINORDER', $iBaseLanguage, false);
				$aPath['link'] = $this->getLink();
				$aPaths[] = $aPath;
			}
		} elseif ( $sFunction == 'showSccpFinished' ) {
			$aPath = array();
			$aPath['title'] = $oLang->translateString('SCCP_FINANCING_BREADCRUMB_FINISHED', $iBaseLanguage, false);
			$aPath['link'] = '';
			$aPaths[] = $aPath;
		}


		return $aPaths;
	}
}

class_alias(Trigger::class,'sccp_trigger');
