<?php
/**
 * This file is part of the SinkaCom CreditPlus Module Package.
 *
 * @link      http://www.sinkacom.de/
 * @copyright (C) SinkaCom AG 2015-2019
 * @version   OXID eShop CE
 */
/**
 * Created by PhpStorm.
 * User: sinkacom
 * Date: 11.04.16
 * Time: 18:01
 */

namespace Sinkacom\CreditPlusModule\Core;

use Sinkacom\CreditPlusModule\Model as SCModel;
use OxidEsales\Eshop\Core as ESCore;
use OxidEsales\Eshop\Application\Model as ESModel;

class Email extends Email_parent {
	public function sendOrderEmailToUser($oOrder, $sSubject = null) {
		if ( $oOrder->oxorder__oxpaymenttype->value == 'sccp_financing' ) {
			$this->addRetryURL($oOrder);
		}
		return parent::sendOrderEmailToUser($oOrder, $sSubject);
	}
	public function sendOrderEmailToOwner($oOrder, $sSubject = null) {
		if ( $oOrder->oxorder__oxpaymenttype->value == 'sccp_financing' ) {
			$this->addRetryURL($oOrder);
		}
		return parent::sendOrderEmailToOwner($oOrder, $sSubject);
	}

	/**
	 * @param SCModel\Order|ESModel\Order $oOrder
	 */
	protected function addRetryURL($oOrder) {
		$oConfig = $this->getConfig();
		if ( $oConfig->getShopConfVar('sTransactionMode',null,'module:sccp') == 'postorder' ) {
			$sDON = $oOrder->oxorder__oxtransid->value;
			$sOXID = $oOrder->oxorder__oxid->value;
			$oShop = $oConfig->getActiveShop();
			try{
				/** @var ESCore\UtilsUrl $oUtilsURL */
				$oUtilsURL = oxNew(ESCore\UtilsUrl::class);
				$sShownAs = $oConfig->getShopConfVar('sCPShownAs',$oShop->oxshops__oxid->value,'module:sccp');
				$sRetryURL = $oConfig->getConfigParam('sShopURL').$oUtilsURL->processUrl('index.php?cl=sinkacom_creditplusmodule_trigger&fnc=showSccpPopup&don='.$sDON.'&oxid='.$sOXID);
				if ( $sShownAs == 'popup' ) {
					// Since Popup == default, this is already set in the line before the if above
					// $sRetryURL = $oConfig->getConfigParam('sShopURL').$oUtilsURL->processUrl('index.php?cl=sccp_trigger&fnc=showSccpPopup&don='.$sDON.'&oxid='.$sOXID);
				} elseif ( $sShownAs == 'iframe' ) {
					$sRetryURL = $oConfig->getConfigParam('sShopURL').$oUtilsURL->processUrl('index.php?cl=sinkacom_creditplusmodule_trigger&fnc=showSccpIframe&don='.$sDON.'&oxid='.$sOXID);
				}
			} catch ( ESCore\Exception\SystemComponentException $oEx ) {
				// Class oxUtilsUrl not found, doesn't happen
				$sRetryURL = '';
			}


			$this->_aViewData['sRetryURL'] = $sRetryURL;
		}
	}
}

