<?php
/**
 * Created by PhpStorm.
 * @author Mihovil.Bubnjar
 * @date 03.01.2019
 * @time 17:43
 */

namespace Sinkacom\CreditPlusModule\Lib\CreditPlusHelper;

abstract class AbstractShopLogger {
	/**
	 * Write SoapClient Request-Info
	 * to Log-File
	 *
	 * @param string $sToday Timestamp for log file entry
	 * @param bool $bError Whether or not this file is prefixed with error
	 * @param string $sFunctionName Which function has been called
	 * @param string $sContent Content to log
	 */
	abstract public function writeLastRequestInfo( $sToday = '', $bError = false, $sFunctionName = '', $sContent = '' );
	/**
	 * Write SoapClient Request-Info
	 * to Log-File
	 *
	 * @param string $sToday Timestamp for log file entry
	 * @param bool $bError Whether or not to use error prefix in file name
	 * @param string $sFunctionName Which function was called
	 * @param string $sContent Content to log
	 */
	abstract public function writeLastResponseInfo( $sToday = '', $bError = false, $sFunctionName = '', $sContent = '' );
	/**
	 * Write Request-Information-Data
	 * to Log-File
	 *
	 * @param string $sToday Timestamp for log file entry
	 * @param string $sFunctionName The called API function name (e.g. getContracts)
	 * @param string[] $aArgumentData The arguments passed to $sFunctionName
	 * @param bool $bError true, if logged event is an error
	 */
	abstract public function writeRequestInformation( $sToday = '', $bError = false, $sFunctionName = '', $aArgumentData = array() );

	/**
	 * Cleans up content for insertion
	 * In this default run it just removes new lines
	 * @param string $sContent
	 * @return string
	 */
	protected function cleanUpContent( $sContent = '' ) {
		if ( strpos($sContent, "\r\n") !== false ) {
			$sContent = str_replace("\r\n", "\n", $sContent);
		}
		if ( strpos($sContent, "\r") !== false ) {
			$sContent = str_replace("\r", "\n", $sContent);
		}
		while ( strpos($sContent, "\n\n") !== false ) {
			$sContent = str_replace("\n\n", "\n", $sContent);
		}
		if ( strpos($sContent, "\n") !== false ) {
			$sContent = str_replace("\n", " ", $sContent);
		}
		if ( strpos($sContent, "    ") !== false ) {
			$sContent = str_replace("    ", "\t", $sContent);
		}
		return $sContent;
	}
}
