<?php
/**
 * This file is part of the SinkaCom CreditPlus Module Package.
 *
 * @link      http://www.sinkacom.de/
 * @copyright (C) SinkaCom AG 2015-2019
 * @version   OXID eShop CE
 */
/**
 * Created by PhpStorm.
 * @author Mihovil.Bubnjar
 * @date 04.01.2019
 * @time 15:18
 */
namespace Sinkacom\CreditPlusModule\Model;
use Exception;
use OxidEsales\Eshop\Core\Model\BaseModel;

class LogEntry extends BaseModel {
	protected $_sClassName = LogEntry::class;
	protected $_sCoreTable = 'sccp_logentry';
	protected $_aFieldNames = array(
		'oxid' => 0,
		'sclogtime' => 0,
		'sccalledfunction' => 0,
		'scerror' => 0,
		'sctype' => 0,
		'sclogentry' => 0,
	);

	public function assign( $aDBRecord ) {
		if ( isset($aDBRecord['sccp_logentry__sclogentry']) ) {
			try {
				if ( is_string($aDBRecord['sccp_logentry__sclogentry']) ) {
					$aUnserialized = @unserialize($aDBRecord['sccp_logentry__sclogentry']);
					if ( $aUnserialized ) {
						$aDBRecord['sccp_logentry__sclogentry'] = $aUnserialized;
					}
				}
			} catch ( Exception $oEx ) {
				// Nothing to catch, just roll with it
			}
		}
		if ( isset($aDBRecord['sclogentry']) ) {
			try {
				if ( is_string($aDBRecord['sclogentry']) ) {
					$aUnserialized = @unserialize($aDBRecord['sclogentry']);
					if ( $aUnserialized ) {
						$aDBRecord['sclogentry'] = $aUnserialized;
					}
				}
			} catch ( Exception $oEx ) {
				// Nothing to catch, just roll with it
			}
		}
		return parent::assign( $aDBRecord );
	}

	public function save() {
		if ( $aUnserializedValue = $this->sccp_logentry__sclogentry->value ) {
			try {
				if ( is_string($aUnserializedValue) ) {
					$aUnserialized = @unserialize($aUnserializedValue);
					if ( $aUnserialized ) {
						$aUnserializedValue = $aUnserialized;
					}
				}
			} catch ( Exception $oEx ) {
				// Nothing to catch, value was already unserialized
			}
			$sSerializedValue = serialize($aUnserializedValue);
			$this->sccp_logentry__sclogentry->setValue($sSerializedValue);
		}
		return parent::save();
	}
}
