<?php
/**
 * This file is part of the SinkaCom CreditPlus Module Package.
 *
 * @link      http://www.sinkacom.de/
 * @copyright (C) SinkaCom AG 2015-2019
 * @version   OXID eShop CE
 */
/**
 * Created by PhpStorm.
 * User: sinkacom
 * Date: 23.02.16
 * Time: 13:02
 */
namespace Sinkacom\CreditPlusModule\Model;

use OxidEsales\Eshop\Core as ESCore;

class OfferedOption extends ESCore\Model\BaseModel {
	protected $_sClassName = 'sccp_offered_option';

	protected $_sCoreTable = 'sccp_offered_option';

	public function save() {
		$sPossiblyGermanValue = $this->sccp_offered_option__sccp_interest->value;
		if ( strpos($sPossiblyGermanValue,',') ) {
			$sDefinitelyGermanValue = str_replace(array('.',','),array('','.'),$sPossiblyGermanValue);
			$this->sccp_offered_option__sccp_interest->setValue(floatval($sDefinitelyGermanValue));
		}
		return parent::save();
	}

	public function countAssignedProductGroups() {
		try{
			$oDB = ESCore\DatabaseProvider::getDb(ESCore\DatabaseProvider::FETCH_MODE_NUM);
			$sOxid = $oDB->quote($this->getId());
			/** @var ESCore\Database\Adapter\Doctrine\ResultSet $oRes */
			$oRes = $oDB->execute("SELECT COUNT(*) assignedprodgroups FROM sccp_offered_option_prodgroup soop WHERE soop.sccp_offered_option_id = $sOxid");
			if ( $oRes && $oRes->fields[0] ) {
				return $oRes->fields[0];
			}
		} catch( ESCore\Exception\DatabaseConnectionException $oEx ) {
			// Database connection failed
			return 0;
		} catch( ESCore\Exception\DatabaseErrorException $oEx ) {
			// Database query failed
			return 0;
		}
		return 0;
	}
}

class_alias(OfferedOption::class,'sccp_offered_option');
