<?php
/**
 * This file is part of the SinkaCom CreditPlus Module Package.
 *
 * @link      http://www.sinkacom.de/
 * @copyright (C) SinkaCom AG 2015-2019
 * @version   OXID eShop CE
 */
/**
 * Created by PhpStorm.
 * User: sinkacom
 * Date: 23.02.16
 * Time: 13:02
 */

namespace Sinkacom\CreditPlusModule\Model;

use OxidEsales\Eshop\Core as ESCore;

class Prodgroup extends ESCore\Model\BaseModel {
	protected $_sClassName = 'sccp_prodgroup';

	protected $_sCoreTable = 'sccp_prodgroup';

	public function countAssignedProducts() {
		try{
			$oDB = ESCore\DatabaseProvider::getDb(ESCore\DatabaseProvider::FETCH_MODE_NUM);
			$sOxid = $oDB->quote($this->getId());
			/** @var ESCore\Database\Adapter\Doctrine\ResultSet $oRes */
			$oRes = $oDB->select("SELECT COUNT(*) assignedprods FROM sccp_prodgroup_article pga WHERE pga.sccp_prodgroup_id = $sOxid");
			if ( $oRes && $oRes->fields[0] ) {
				return $oRes->fields[0];
			}
		} catch( ESCore\Exception\DatabaseConnectionException $oEx ) {
			// Database connection failed
			return 0;
		} catch( ESCore\Exception\DatabaseErrorException $oEx ) {
			// Database query failed
			return 0;
		}

		return 0;
	}
}

class_alias(Prodgroup::class,'sccp_prodgroup');
