#!/usr/bin/env php
<?php
/**
 * Created by PhpStorm.
 * @author Mihovil.Bubnjar
 * @date 02.01.2019
 * @time 14:38
 */

if ( interface_exists('SessionHandlerInterface') && interface_exists('SessionIdInterface') ) {
	// PHP >= 5.5.1 supports SessionIdInterface
	abstract class sccp_sessiongrave_sh implements SessionHandlerInterface, SessionIdInterface {}
} elseif ( interface_exists('SessionHandlerInterface') ) {
	// PHP >= 5.4.0 supports SessionHandlerInterface
	abstract class sccp_sessiongrave_sh implements SessionHandlerInterface {}
} else {
	// Everything else supports the other way down there
	abstract class sccp_sessiongrave_sh {}
}

/**
 * Class sccp_sessiongrave
 * Throws away session data, because on CronJobs you don't need working sessions
 */
class sccp_sessiongrave extends sccp_sessiongrave_sh {
	public function open($sSavePath, $sSessionName) {
		return true;
	}

	public function close() {
		return true;
	}

	public function read($sSessionId) {
		return '';
	}

	public function write($sSessionId, $sData) {
		return true;
	}

	public function destroy($sSessionId) {
		return true;
	}

	public function gc($iLifetime) {
		return true;
	}

	public function create_sid() {
		return 'wurst';
	}

	public function validate_sid($sSessionId) {
		return true;
	}

	public function update_timestamp() {
		return true;
	}
}

// This is only true if called by cron or shell
if ( !isset($_SERVER['REMOTE_ADDR']) ) {
	$_SERVER['REMOTE_ADDR'] = '127.225.19.86';
	$sDocRoot = dirname(dirname(dirname(__DIR__))).'/';
	$_SERVER['SCRIPT_FILENAME'] = $sDocRoot.'admin/index.php';
	$_SERVER['DOCUMENT_ROOT'] = $sDocRoot;
	$_SERVER['REQUEST_METHOD'] = 'GET';
	$_SERVER['SERVER_PROTOCOL'] = 'HTTP/1.1';
	$_SERVER['SCRIPT_NAME'] = '/admin/index.php';
	$_SERVER['PHP_SELF'] = '/admin/index.php';

	if ( ($argc > 0 ) && ( $argv[1] == 'mail' ) ) {
		$_SERVER['REQUEST_URI'] = '/admin/index.php?cl=sinkacom_creditplusmodule_cronjob_mail&fnc=execmail';
		$_SERVER['QUERY_STRING'] = 'cl=sinkacom_creditplusmodule_cronjob_mail&fnc=execmail';
		$_GET['cl'] = 'sinkacom_creditplusmodule_cronjob_mail';
		$_GET['fnc'] = 'execmail';
		$_REQUEST['cl'] = 'sinkacom_creditplusmodule_cronjob_mail';
		$_REQUEST['fnc'] = 'execmail';
	} elseif ( ( $argc > 0 ) && ( $argv[1] == 'main' ) ) {
		$_SERVER['REQUEST_URI'] = '/admin/index.php?cl=sinkacom_creditplusmodule_cronjob_main&fnc=execmain';
		$_SERVER['QUERY_STRING'] = 'cl=sinkacom_creditplusmodule_cronjob_main&fnc=execmain';
		$_GET['cl'] = 'sinkacom_creditplusmodule_cronjob_main';
		$_GET['fnc'] = 'execmain';
		$_REQUEST['cl'] = 'sinkacom_creditplusmodule_cronjob_main';
		$_REQUEST['fnc'] = 'execmain';
	} else {
		echo 'Usage: '.$argv[0].' (main|mail)';
	}
	$oSessionHandler = new sccp_sessiongrave();
	// if php >= 5.4.0
	if ( interface_exists('SessionHandlerInterface') ) {
		session_set_save_handler($oSessionHandler);
		// else
	} else {
		session_set_save_handler(
			array($oSessionHandler, 'open'),
			array($oSessionHandler, 'close'),
			array($oSessionHandler, 'read'),
			array($oSessionHandler, 'write'),
			array($oSessionHandler, 'destroy'),
			array($oSessionHandler, 'gc')
		);
	}
	require($_SERVER['SCRIPT_FILENAME']);
}
