<?php
namespace SicoCreditPlus\Controller;

use Shopware\Core\Content\Product\Exception\ProductNotFoundException;
use Shopware\Core\Content\Product\ProductDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Core\System\Snippet\SnippetService;
use Shopware\Storefront\Controller\StorefrontController;
use SicoCreditPlus\Components\SicoCreditPlusHelper;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Contracts\Translation\TranslatorInterface;

#[Route(defaults: ['_routeScope' => ['storefront']])]
class SicoModalController extends StorefrontController{

    /** @var SicoCreditPlusHelper|null $oCreditPlusHelper */
    protected ?SicoCreditPlusHelper $oCreditPlusHelper = null;

    /** @var SnippetService|TranslatorInterface */
    private TranslatorInterface|SnippetService $oTranslator;

    public function __construct(
        SicoCreditPlusHelper $creditPlusHelper,
        TranslatorInterface $translator
    ){
        $this->oCreditPlusHelper = $creditPlusHelper;
        $this->oTranslator = $translator;
    }

    #[Route(path: '/modal/creditplus/ratetable/{sProductId}', name: 'frontend.creditplus.modal.ratetable', defaults: ['XmlHttpRequest' => true], methods: ['GET'])]
    public function getRatetable(Request $request, SalesChannelContext $context, string $sProductId): Response
    {
        /** @var EntityRepository $oProductRepo */
        $oProductRepo = $this->container->get(ProductDefinition::ENTITY_NAME.'.repository');
        $oProduct = $oProductRepo->search(new Criteria([$sProductId]),$context->getContext())->first();
        if($oProduct == null){
            throw new ProductNotFoundException($sProductId);
        }

        $this->oCreditPlusHelper->setContext($context->getContext());
        $this->oCreditPlusHelper->setSalesChannelContext($context);

        $oCurrency = $context->getCurrency();
        $sCurrency = $context->getCurrencyId();
        $oPrice = $oProduct->getPrice();
        if($oPrice){
            $dPrice = $oPrice->getCurrencyPrice($sCurrency)->getGross();
            // Hier dürfen keine Monate zurückgegeben werden, wenn der Kredit nur auf ein oder mehrere Produkte beschränkt ist.
            $aMonths = $this->oCreditPlusHelper->getFinancingMonths($context,$oCurrency, $oProduct,null,$dPrice);
        }
        else {
            $aMonths = $this->oCreditPlusHelper->getFinancingMonths($context,$oCurrency, $oProduct);
        }

        $i = 0;
        $aSicoLowestRates = [];
        if(count($aMonths) >= 3){
            foreach($aMonths as $oMonth){
                if($i >= (count($aMonths) - 3)){
                    $aSicoLowestRates = array_merge($aSicoLowestRates,[$oMonth]);
                }
                $i++;
            }
        } else {
            $aSicoLowestRates = $aMonths;
        }

        $bShowPAngVText = ($this->oTranslator->trans('sicoCreditplus.tabs.sccppangvtext_text') != '');
        return $this->renderStorefront('@SicoCreditPlus/storefront/cpModal/ratetable.html.twig',[
            'aSicoRateTable' => $aMonths,
            'aSicoLowestRates' => $aSicoLowestRates,
            'bShowPAngVText' => $bShowPAngVText
        ]);
    }
}
