<?php
/**
 * Created by PhpStorm.
 * @author mihovil.bubnjar
 * @date 21.05.2024
 * @time 16:03
 */

namespace SicoCreditPlus\Core\Content\Flow\Dispatching\Action;

use Shopware\Core\Checkout\Order\OrderEntity;
use Shopware\Core\Content\Flow\Dispatching\Action\FlowAction;
use Shopware\Core\Content\Flow\Dispatching\StorableFlow;
use Shopware\Core\Framework\Event\OrderAware;
use Shopware\Core\Framework\Uuid\Uuid;
use Shopware\Core\System\SalesChannel\Context\AbstractSalesChannelContextFactory;
use SicoCreditPlus\Components\SicoCreditPlusHelper;
use SicoCreditPlus\Components\SicoCreditPlusLogger;

class CreditPlusDispatchedAction extends FlowAction
{
	private ?SicoCreditPlusLogger $oLogger = null;
	private ?SicoCreditPlusHelper $oHelper = null;
	private ?AbstractSalesChannelContextFactory $oSalesChannelContextFactory = null;

	public function __construct(SicoCreditPlusLogger $oLogger, SicoCreditPlusHelper $oHelper, AbstractSalesChannelContextFactory $oSalesChannelContextFactory)
	{
		if ( $this->oLogger == null ) {
			$this->oLogger = $oLogger;
		}
		if ( $this->oHelper == null ) {
			$this->oHelper = $oHelper;
		}
		if ( $this->oSalesChannelContextFactory == null ) {
			$this->oSalesChannelContextFactory = $oSalesChannelContextFactory;
		}
	}

	/**
	 * @inheritDoc
	 */
	public function requirements(): array
	{
		return [OrderAware::class];
	}

	public function handleFlow(StorableFlow $flow): void
	{
		if ( $flow->hasData(OrderAware::ORDER) ) {
			/** @var OrderEntity $oOrder */
			$oOrder = $flow->getData(OrderAware::ORDER);
			$this->oLogger->log(false,'Order ' . $oOrder->getId() . ' will be marked as dispatched', [], $oOrder->getSalesChannelId());
			$oSalesChannelContext = $this->oSalesChannelContextFactory->create(Uuid::randomHex(), $oOrder->getSalesChannelId());
			$this->oHelper->setSalesChannelContext($oSalesChannelContext);
			$aError = $this->oHelper->sendOrder($oOrder);
			if ( $aError ) {
				$this->oLogger->log(true,'Error while sending order to CreditPlus', $aError, $oOrder->getSalesChannelId());
				$this->oHelper->sendActivationFailedMail($oOrder);
			}
		}
	}

	public static function getName(): string
	{
		return 'action.creditplus.dispatched';
	}
}
