<?php
/**
 * Created by PhpStorm.
 * @author mihovil.bubnjar
 * @date 16.08.2023
 * @time 14:49
 */

namespace SicoCreditPlus\Core\Content\SicoCreditPlusSavedCart;

use Exception;
use Shopware\Core\Checkout\Cart\Cart;
use Shopware\Core\Checkout\Cart\Delivery\Struct\DeliveryCollection;
use Shopware\Core\Checkout\Cart\LineItem\CartDataCollection;
use Shopware\Core\Checkout\Cart\LineItem\LineItemCollection;
use Shopware\Core\Checkout\Cart\Price\Struct\CartPrice;
use Shopware\Core\Checkout\Cart\Transaction\Struct\TransactionCollection;
use Shopware\Core\Checkout\Customer\CustomerEntity;
use Shopware\Core\Checkout\Payment\PaymentMethodEntity;
use Shopware\Core\Checkout\Shipping\ShippingMethodEntity;
use Shopware\Core\Framework\DataAbstractionLayer\Entity;
use Shopware\Core\Framework\DataAbstractionLayer\EntityIdTrait;
use Shopware\Core\System\Country\CountryEntity;
use Shopware\Core\System\Currency\CurrencyEntity;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Core\System\SalesChannel\SalesChannelEntity;
use SicoCreditPlus\Service\Interfaces\SavedCartSerializerInterface;

class SicoCreditPlusSavedCartEntity extends Entity
{
	use EntityIdTrait;

	/**
	 * @var string $token
	 */
	protected string $token = '';

	/**
	 * @var string $name
	 */
	protected string $name = '';

	/**
	 * @var CartPrice|null $price
	 */
	protected ?CartPrice $price = null;

	/**
	 * @var int|null $lineItemCount
	 */
	protected ?int $lineItemCount = null;

	/**
	 * @var LineItemCollection|null $lineItems Transient object, not directly saved in database
	 */
	private ?LineItemCollection $lineItems = null;

	/**
	 * @var DeliveryCollection|null $deliveries
	 */
	private ?DeliveryCollection $deliveries = null;

	/**
	 * @var TransactionCollection|null $transactions
	 */
	private ?TransactionCollection $transactions = null;

	/**
	 * @var string|null $currencyId
	 */
	protected ?string $currencyId = null;

	/**
	 * @var string|null $shippingMethodId
	 */
	protected ?string $shippingMethodId = null;

	/**
	 * @var string|null $paymentMethodId
	 */
	protected ?string $paymentMethodId = null;

	/**
	 * @var string|null $countryId
	 */
	protected ?string $countryId = null;

	/**
	 * @var string|null $customerId
	 */
	protected ?string $customerId = null;

	/**
	 * @var string|null $salesChannelId
	 */
	protected ?string $salesChannelId = null;

	/**
	 * @var array|null $ruleIds
	 */
	protected ?array $ruleIds = [];

	// createdAt + updateAt come from Entity
	protected int $autoIncrement;

	/**
	 * @var bool $compressed
	 */
	protected bool $compressed = false;

	/**
	 * @var string $payload
	 */
	protected string $payload = '';

	/**
	 * @var string $dealerOrderNumber
	 */
	protected string $dealerOrderNumber = '';

	/**
	 * @var CurrencyEntity|null $currency
	 */
	protected ?CurrencyEntity $currency = null;

	/**
	 * @var ShippingMethodEntity|null $shippingMethod
	 */
	protected ?ShippingMethodEntity $shippingMethod = null;

	/**
	 * @var PaymentMethodEntity|null $paymentMethod
	 */
	protected ?PaymentMethodEntity $paymentMethod = null;

	/**
	 * @var CountryEntity|null $country
	 */
	protected ?CountryEntity $country = null;

	/**
	 * @var CustomerEntity|null $customer
	 */
	protected ?CustomerEntity $customer = null;

	/**
	 * @var SalesChannelEntity|null $salesChannel
	 */
	protected ?SalesChannelEntity $salesChannel = null;

	/**
	 * @var CartDataCollection|null $data
	 */
	protected ?CartDataCollection $data = null;

	public function __construct()
	{
		if ( $this->lineItems === null ) {
			$this->lineItems = new LineItemCollection();
		}
		if ( $this->data === null ) {
			$this->data = new CartDataCollection();
		}
		if ( $this->deliveries === null ) {
			$this->deliveries = new DeliveryCollection();
		}
		if ( $this->transactions === null ) {
			$this->transactions = new TransactionCollection();
		}
	}

	/**
	 * @return string
	 */
	public function getToken(): string
	{
		return $this->token;
	}

	/**
	 * @param string $token
	 */
	public function setToken(string $token): void
	{
		$this->token = $token;
	}

	/**
	 * @return string
	 */
	public function getName(): string
	{
		return $this->name;
	}

	/**
	 * @param string $name
	 */
	public function setName(string $name): void
	{
		$this->name = $name;
	}

	/**
	 * @return CartPrice|null
	 */
	public function getPrice(): ?CartPrice
	{
		return $this->price;
	}

	/**
	 * @param CartPrice|null $price
	 */
	public function setPrice(?CartPrice $price): void
	{
		$this->price = $price;
	}

	/**
	 * @return int|null
	 */
	public function getLineItemCount(): ?int
	{
		return $this->lineItemCount;
	}

	/**
	 * @param int|null $lineItemCount
	 */
	public function setLineItemCount(?int $lineItemCount): void
	{
		$this->lineItemCount = $lineItemCount;
	}

	/**
	 * @return LineItemCollection|null
	 */
	public function getLineItems(): ?LineItemCollection
	{
		return $this->lineItems;
	}

	/**
	 * @param LineItemCollection|null $lineItems
	 */
	public function setLineItems(?LineItemCollection $lineItems): void
	{
		$this->lineItems = $lineItems;
	}

	/**
	 * @return DeliveryCollection|null
	 */
	public function getDeliveries(): ?DeliveryCollection
	{
		return $this->deliveries;
	}

	/**
	 * @param DeliveryCollection|null $deliveries
	 */
	public function setDeliveries(?DeliveryCollection $deliveries): void
	{
		$this->deliveries = $deliveries;
	}

	/**
	 * @return TransactionCollection|null
	 */
	public function getTransactions(): ?TransactionCollection
	{
		return $this->transactions;
	}

	/**
	 * @param TransactionCollection|null $transactions
	 */
	public function setTransactions(?TransactionCollection $transactions): void
	{
		$this->transactions = $transactions;
	}

	/**
	 * @return string|null
	 */
	public function getCurrencyId(): ?string
	{
		return $this->currencyId;
	}

	/**
	 * @param string|null $currencyId
	 */
	public function setCurrencyId(?string $currencyId): void
	{
		$this->currencyId = $currencyId;
	}

	/**
	 * @return string|null
	 */
	public function getShippingMethodId(): ?string
	{
		return $this->shippingMethodId;
	}

	/**
	 * @param string|null $shippingMethodId
	 */
	public function setShippingMethodId(?string $shippingMethodId): void
	{
		$this->shippingMethodId = $shippingMethodId;
	}

	/**
	 * @return string|null
	 */
	public function getPaymentMethodId(): ?string
	{
		return $this->paymentMethodId;
	}

	/**
	 * @param string|null $paymentMethodId
	 */
	public function setPaymentMethodId(?string $paymentMethodId): void
	{
		$this->paymentMethodId = $paymentMethodId;
	}

	/**
	 * @return string|null
	 */
	public function getCountryId(): ?string
	{
		return $this->countryId;
	}

	/**
	 * @param string|null $countryId
	 */
	public function setCountryId(?string $countryId): void
	{
		$this->countryId = $countryId;
	}

	/**
	 * @return string|null
	 */
	public function getCustomerId(): ?string
	{
		return $this->customerId;
	}

	/**
	 * @param string|null $customerId
	 */
	public function setCustomerId(?string $customerId): void
	{
		$this->customerId = $customerId;
	}

	/**
	 * @return string|null
	 */
	public function getSalesChannelId(): ?string
	{
		return $this->salesChannelId;
	}

	/**
	 * @param string|null $salesChannelId
	 */
	public function setSalesChannelId(?string $salesChannelId): void
	{
		$this->salesChannelId = $salesChannelId;
	}

	/**
	 * @return string[]
	 */
	public function getRuleIds(): array
	{
		if ( !is_array($this->ruleIds) ) {
			$this->ruleIds = [];
		}
		return $this->ruleIds;
	}

	/**
	 * @param string[]|null $ruleIds
	 */
	public function setRuleIds(?array $ruleIds): void
	{
		if ( !$ruleIds ) { $ruleIds = []; }
		$this->ruleIds = $ruleIds;
	}

	/**
	 * @return int
	 */
	public function getAutoIncrement(): int
	{
		return $this->autoIncrement;
	}

	/**
	 * @param int $autoIncrement
	 */
	public function setAutoIncrement(int $autoIncrement): void
	{
		$this->autoIncrement = $autoIncrement;
	}

	/**
	 * @return bool
	 */
	public function isCompressed(): bool
	{
		return $this->compressed;
	}

	/**
	 * @param bool $compressed
	 */
	public function setCompressed(bool $compressed): void
	{
		$this->compressed = $compressed;
	}

	/**
	 * @return string
	 */
	public function getPayload(): string
	{
		return $this->payload;
	}

	/**
	 * @param string $payload
	 */
	public function setPayload(string $payload): void
	{
		$this->payload = $payload;
	}

	/**
	 * @return string
	 */
	public function getDealerOrderNumber(): string
	{
		return $this->dealerOrderNumber;
	}

	/**
	 * @param string $dealerOrderNumber
	 */
	public function setDealerOrderNumber(string $dealerOrderNumber): void
	{
		$this->dealerOrderNumber = $dealerOrderNumber;
	}

	/**
	 * @return CurrencyEntity|null
	 */
	public function getCurrency(): ?CurrencyEntity
	{
		return $this->currency;
	}

	/**
	 * @param CurrencyEntity|null $currency
	 */
	public function setCurrency(?CurrencyEntity $currency): void
	{
		$this->currency = $currency;
	}

	/**
	 * @return ShippingMethodEntity|null
	 */
	public function getShippingMethod(): ?ShippingMethodEntity
	{
		return $this->shippingMethod;
	}

	/**
	 * @param ShippingMethodEntity|null $shippingMethod
	 */
	public function setShippingMethod(?ShippingMethodEntity $shippingMethod): void
	{
		$this->shippingMethod = $shippingMethod;
	}

	/**
	 * @return PaymentMethodEntity|null
	 */
	public function getPaymentMethod(): ?PaymentMethodEntity
	{
		return $this->paymentMethod;
	}

	/**
	 * @param PaymentMethodEntity|null $paymentMethod
	 */
	public function setPaymentMethod(?PaymentMethodEntity $paymentMethod): void
	{
		$this->paymentMethod = $paymentMethod;
	}

	/**
	 * @return CountryEntity|null
	 */
	public function getCountry(): ?CountryEntity
	{
		return $this->country;
	}

	/**
	 * @param CountryEntity|null $country
	 */
	public function setCountry(?CountryEntity $country): void
	{
		$this->country = $country;
	}

	/**
	 * @return CustomerEntity|null
	 */
	public function getCustomer(): ?CustomerEntity
	{
		return $this->customer;
	}

	/**
	 * @param CustomerEntity|null $customer
	 */
	public function setCustomer(?CustomerEntity $customer): void
	{
		$this->customer = $customer;
	}

	/**
	 * @return SalesChannelEntity|null
	 */
	public function getSalesChannel(): ?SalesChannelEntity
	{
		return $this->salesChannel;
	}

	/**
	 * @param SalesChannelEntity|null $salesChannel
	 */
	public function setSalesChannel(?SalesChannelEntity $salesChannel): void
	{
		$this->salesChannel = $salesChannel;
	}

	/**
	 * @return CartDataCollection|null
	 */
	public function getData(): ?CartDataCollection
	{
		return $this->data;
	}

	/**
	 * @param CartDataCollection|null $data
	 */
	public function setData(?CartDataCollection $data): void
	{
		$this->data = $data;
	}

	/**
	 * @param SalesChannelContext $oContext
	 * @param Cart $oCart
	 * @param SavedCartSerializerInterface $oSavedCartSerializer
	 * @return void
	 * @throws Exception
	 */
	public function createFromCart(SalesChannelContext $oContext, Cart $oCart, SavedCartSerializerInterface $oSavedCartSerializer)
	{
		$this->setToken($oCart->getToken());
		$this->setName('SavedCart on '.date('Y-m-d H:i:s'));
		$this->setPrice($oCart->getPrice());
		$oLineItems = $oCart->getLineItems();
		$this->setLineItemCount($oLineItems->count());
		$this->setLineItems($oLineItems);
		$this->setDeliveries($oCart->getDeliveries());
		$this->setTransactions($oCart->getTransactions());
		$this->setCurrencyId($oContext->getCurrencyId());
		$this->setCurrency($oContext->getCurrency());
		$this->setCustomerId($oContext->getCustomerId());
		$this->setCustomer($oContext->getCustomer());
		$oShippingMethod = $oContext->getShippingMethod();
		$this->setShippingMethodId($oShippingMethod->getId());
		$this->setShippingMethod($oShippingMethod);
		$oPaymentMethod = $oContext->getPaymentMethod();
		$this->setPaymentMethodId($oPaymentMethod->getId());
		$this->setPaymentMethod($oPaymentMethod);
		$oCountry = $oContext->getShippingLocation()->getCountry();
		$this->setCountryId($oCountry->getId());
		$this->setCountry($oCountry);
		$this->setSalesChannelId($oContext->getSalesChannelId());
		$this->setSalesChannel($oContext->getSalesChannel());
		$this->setRuleIds($oCart->getRuleIds());
		$oData = $oCart->getData();
		if ( $sDealerOrderNumber = $oData->get('cpDealerOrderNumber') ) {
			$this->setDealerOrderNumber($sDealerOrderNumber);
		}
		$this->setData($oData);
		$this->setPayload($oSavedCartSerializer->serialize($this));
	}

	public function fillFromPayload(SavedCartSerializerInterface $oSavedCartSerializer)
	{
		$oSavedCart = $oSavedCartSerializer->unserialize($this->getPayload());
		$this->setLineItems($oSavedCart->getLineItems());
		$this->setData($oSavedCart->getData());
		$this->setDeliveries($oSavedCart->getDeliveries());
		$this->setTransactions($oSavedCart->getTransactions());
	}

	public function getVars(): array
	{
		$aReturn = parent::getVars();
		$aPrivateFields = [
			'salesChannel',
			'shippingMethod',
			'paymentMethod',
			'currency',
			'customer',
			'country',
		];
		foreach ( $aPrivateFields as $sPrivateField ) {
			unset($aReturn[$sPrivateField]);
		}
		return $aReturn;
	}
}
