<?php
/**
 * Created by PhpStorm.
 * User: Philipp.Holzmann
 * Date: 08.01.2020
 * Time: 13:55
 */
namespace SicoCreditPlus\Core\Content\SicoOfferedOption;

use Shopware\Core\Framework\DataAbstractionLayer\EntityDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\Field\BoolField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\FkField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\PrimaryKey;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\Required;
use Shopware\Core\Framework\DataAbstractionLayer\Field\FloatField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\IdField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\IntField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ManyToOneAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\StringField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use SicoCreditPlus\Core\Content\SicoProductgroup\SicoProductgroupDefinition;

class SicoOfferedOptionDefinition extends EntityDefinition{

	public const ENTITY_NAME = 'sico_offered_option';

	public function getEntityName(): string
	{
		return self::ENTITY_NAME;
	}

	public function getEntityClass(): string
	{
		return SicoOfferedOptionEntity::class;
	}

	public function getCollectionClass(): string
	{
		return SicoOfferedOptionCollection::class;
	}


	protected function defineFields(): FieldCollection
	{
		return new FieldCollection([
			(new IdField('id','id'))->addFlags(new Required(),new PrimaryKey()),
			(new IntField('sico_months','sicoMonths'))->addFlags(new Required()),
			(new FloatField('sico_interest','sicoInterest')),
			(new StringField('sico_prodcode','sicoProdcode')),
			(new BoolField('sico_active','sicoActive')),
			(new FloatField('sico_ratefactor','sicoRatefactor')),
			(new FkField('sico_prodgroup','sicoProdgroupId',SicoProductgroupDefinition::class)),
			(new ManyToOneAssociationField('sicoProdgroup','sico_prodgroup',SicoProductgroupDefinition::class))

		]);
	}



}
