<?php
/**
 * Created by PhpStorm.
 * User: Philipp.Holzmann
 * Date: 08.01.2020
 * Time: 14:29
 */
namespace SicoCreditPlus\Core\Content\SicoProductgroup;

use Shopware\Core\Content\Product\ProductCollection;
use Shopware\Core\Content\ProductStream\ProductStreamEntity;
use Shopware\Core\Framework\DataAbstractionLayer\Entity;
use Shopware\Core\Framework\DataAbstractionLayer\EntityIdTrait;
use SicoCreditPlus\Core\Content\SicoOfferedOption\SicoOfferedOptionCollection;
use SicoCreditPlus\Core\Content\SicoProductgroupSalesChannel\SicoProductgroupSalesChannelCollection;

class SicoProductgroupEntity extends Entity{
	use EntityIdTrait;

	/**
	 * @var string
	 */
	protected $sicoName;

	/**
	 * @var int
	 */
	protected $sicoProductTypeId;

	/**
	 * @var int
	 */
	protected $sicoProductClassId;

	/**
	 * @var ProductCollection|null
	 */
	protected $product;

	/**
	 * @var SicoOfferedOptionCollection
	 */
	protected $offeredOptions;

    /** @var SicoProductgroupSalesChannelCollection|null */
    protected $prodgroupSalesChannel;

	/**
	 * @var string|null
	 */
	protected $dynamicProductGroupId = null;

	/**
	 * @var ProductStreamEntity|null
	 */
	protected $dynamicProductGroup;

	/**
	 * @return string
	 */
	public function getSicoName(): string
	{
		return $this->sicoName;
	}

	/**
	 * @param string $sicoName
	 */
	public function setSicoName(string $sicoName): void
	{
		$this->sicoName = $sicoName;
	}

	/**
	 * @return int
	 */
	public function getSicoProductTypeId(): int
	{
		return $this->sicoProductTypeId;
	}

	/**
	 * @param int $sicoProductTypeId
	 */
	public function setSicoProductTypeId(int $sicoProductTypeId): void
	{
		$this->sicoProductTypeId = $sicoProductTypeId;
	}

	/**
	 * @return int
	 */
	public function getSicoProductClassId(): int
	{
		return $this->sicoProductClassId;
	}

	/**
	 * @param int $sicoProductClassId
	 */
	public function setSicoProductClassId(int $sicoProductClassId): void
	{
		$this->sicoProductClassId = $sicoProductClassId;
	}

	/**
	 * @return ProductCollection|null
	 */
	public function getProduct(): ?ProductCollection
	{
		return $this->product;
	}

	/**
	 * @param ProductCollection|null $product
	 */
	public function setProduct(?ProductCollection $product): void
	{
		$this->product = $product;
	}

	/**
	 * @return SicoOfferedOptionCollection
	 */
	public function getOfferedOptions(): SicoOfferedOptionCollection
	{
		return $this->offeredOptions;
	}

	/**
	 * @param SicoOfferedOptionCollection $offeredOptions
	 */
	public function setOfferedOptions(SicoOfferedOptionCollection $offeredOptions): void
	{
		$this->offeredOptions = $offeredOptions;
	}

    /**
     * @return SicoProductgroupSalesChannelCollection
     */
    public function getProdgroupSalesChannel(): ?SicoProductgroupSalesChannelCollection
    {
        return $this->prodgroupSalesChannel;
    }

    /**
     * @param SicoProductgroupSalesChannelCollection $prodgroupSalesChannel
     */
    public function setProdgroupSalesChannel(SicoProductgroupSalesChannelCollection $prodgroupSalesChannel): void
    {
        $this->prodgroupSalesChannel = $prodgroupSalesChannel;
    }

	/**
	 * @return string|null
	 */
	public function getDynamicProductGroupId(): ?string
	{
		return $this->dynamicProductGroupId;
	}

	/**
	 * @param string|null $dynamicProductGroupId
	 */
	public function setDynamicProductGroupId(?string $dynamicProductGroupId): void
	{
		$this->dynamicProductGroupId = $dynamicProductGroupId;
	}

	/**
	 * @return ProductStreamEntity|null
	 */
	public function getDynamicProductGroup(): ?ProductStreamEntity
	{
		return $this->dynamicProductGroup;
	}

	/**
	 * @param ProductStreamEntity|null $dynamicProductGroup
	 */
	public function setDynamicProductGroup(?ProductStreamEntity $dynamicProductGroup): void
	{
		$this->dynamicProductGroup = $dynamicProductGroup;
	}


}
